/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.resourceRoots.ResourceRootIconProvider;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class WebIdeProjectStructureConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private static final Color RESOURCES_COLOR = JBColor.MAGENTA;
    private final Module myModule;
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    protected ModifiableRootModel myModifiableModel;
    protected CommonContentEntriesEditor myEditor;

    public WebIdeProjectStructureConfigurable(Module module2) {
        this.myModule = module2;
    }

    public String getDisplayName() {
        return "Directories";
    }

    public String getHelpTopic() {
        return "reference.webide.settings.project.settings.directories";
    }

    public JComponent createComponent() {
        this.createEditor();
        return this.myTopPanel;
    }

    private void createEditor() {
        if (this.myModule == null) {
            return;
        }
        this.myModifiableModel = (ModifiableRootModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableRootModel>(){

            public ModifiableRootModel compute() {
                return ModuleRootManager.getInstance((Module)WebIdeProjectStructureConfigurable.this.myModule).getModifiableModel();
            }
        });
        ModuleConfigurationStateImpl moduleConfigurationState = new ModuleConfigurationStateImpl(this.myModule.getProject(), (ModulesProvider)new DefaultModulesProvider(this.myModule.getProject())){

            @Override
            public ModifiableRootModel getRootModel() {
                return WebIdeProjectStructureConfigurable.this.myModifiableModel;
            }

            @Override
            public FacetsProvider getFacetsProvider() {
                return DefaultFacetsProvider.INSTANCE;
            }
        };
        this.myEditor = this.createEditor(this.myModule, moduleConfigurationState);
        JComponent component = (JComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JComponent>(){

            public JComponent compute() {
                return WebIdeProjectStructureConfigurable.this.myEditor.createComponent();
            }
        });
        this.myTopPanel.add((Component)component, "Center");
    }

    protected CommonContentEntriesEditor createEditor(@NotNull Module module2, @NotNull ModuleConfigurationState state) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable", "createEditor"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable", "createEditor"));
        }
        return new MyCommonContentEntriesEditor(module2, state, true, new JpsModuleSourceRootType[]{JavaSourceRootType.TEST_SOURCE});
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor == null) {
            return;
        }
        this.myEditor.apply();
        if (this.myModifiableModel.isChanged()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
            this.resetEditor();
        }
    }

    public void reset() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.resetEditor();
    }

    private void resetEditor() {
        this.myEditor.disposeUIResources();
        this.myTopPanel.remove(this.myEditor.getComponent());
        this.createEditor();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[0];
    }

    @NotNull
    public String getId() {
        if ("web-ide.project.structure" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable", "getId"));
        }
        return "web-ide.project.structure";
    }

    public static class OptionContributor
    extends SearchableOptionContributor {
        public void processOptions(@NotNull SearchableOptionProcessor processor2) {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$OptionContributor", "processOptions"));
            }
            processor2.addOptions("directories project structure exclude resource test root content", null, "Directories", "web-ide.project.structure", "Directories", true);
        }
    }

    private static class ResourceRootFolder
    extends ContentFolderBaseImpl {
        protected ResourceRootFolder(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
            if (filePointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$ResourceRootFolder", "<init>"));
            }
            if (contentEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$ResourceRootFolder", "<init>"));
            }
            super(filePointer, contentEntry);
        }
    }

    protected static class MyCommonContentEntriesEditor
    extends CommonContentEntriesEditor {
        private final MultiMap<ContentEntry, VirtualFilePointer> myResourcesRoots = new MultiMap();
        private Disposable myFilePointersDisposable;
        private final Project myProject;
        private final VirtualFilePointerListener DUMMY_LISTENER = new VirtualFilePointerListener(){};

        public MyCommonContentEntriesEditor(Module module2, ModuleConfigurationState moduleConfigurationState, boolean withBorders, JpsModuleSourceRootType<?> ... rootTypes) {
            super(module2.getName(), moduleConfigurationState, withBorders, rootTypes);
            this.myProject = module2.getProject();
            this.reset();
        }

        @Override
        protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project2) {
            return new MyContentEntryTreeEditor(project2, this.getEditHandlers());
        }

        @Override
        protected List<ContentEntry> addContentEntries(VirtualFile[] files2) {
            List<ContentEntry> entries = super.addContentEntries(files2);
            this.addContentEntryPanels(entries.toArray(new ContentEntry[entries.size()]));
            return entries;
        }

        @Override
        public void reset() {
            if (this.myFilePointersDisposable != null) {
                Disposer.dispose((Disposable)this.myFilePointersDisposable);
            }
            this.myResourcesRoots.clear();
            this.myFilePointersDisposable = Disposer.newDisposable();
            WebResourcesPathsConfiguration webResourcesConfig = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesConfig != null) {
                MultiMap<String, String> resourcesRoots = webResourcesConfig.getResourceRoots();
                for (String contentEntryUrl : resourcesRoots.keySet()) {
                    ContentEntry contentEntry = this.findContentEntry(contentEntryUrl);
                    if (contentEntry == null) continue;
                    for (String resourceRoot : resourcesRoots.get((Object)contentEntryUrl)) {
                        this.myResourcesRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(resourceRoot, this.myFilePointersDisposable, this.DUMMY_LISTENER));
                    }
                }
            }
            if (this.myRootTreeEditor != null) {
                ContentEntryEditor editor = this.myRootTreeEditor.getContentEntryEditor();
                if (editor != null) {
                    editor.update();
                }
                this.myRootTreeEditor.update();
            }
        }

        @Nullable
        private ContentEntry findContentEntry(String url) {
            for (ContentEntry contentEntry : this.getModel().getContentEntries()) {
                if (!contentEntry.getUrl().equals(url)) continue;
                return contentEntry;
            }
            return null;
        }

        @Override
        public void disposeUIResources() {
            super.disposeUIResources();
            if (this.myFilePointersDisposable != null) {
                Disposer.dispose((Disposable)this.myFilePointersDisposable);
            }
        }

        @Override
        public void apply() throws ConfigurationException {
            super.apply();
            MultiMap<String, String> resourceRoots = this.getCurrentState();
            WebResourcesPathsConfiguration webResourcesConfig = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesConfig != null) {
                webResourcesConfig.setResourceRoots(resourceRoots);
            }
        }

        private MultiMap<String, String> getCurrentState() {
            MultiMap result2 = new MultiMap();
            for (ContentEntry entry : this.myResourcesRoots.keySet()) {
                ArrayList<String> resourcesRoots = new ArrayList<String>();
                for (VirtualFilePointer filePointer : this.myResourcesRoots.get((Object)entry)) {
                    resourcesRoots.add(filePointer.getUrl());
                }
                result2.put((Object)entry.getUrl(), resourcesRoots);
            }
            return result2;
        }

        @Override
        public boolean isModified() {
            if (super.isModified()) {
                return true;
            }
            WebResourcesPathsConfiguration webResourcesConfig = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesConfig != null) {
                MultiMap<String, String> original = webResourcesConfig.getResourceRoots();
                MultiMap<String, String> current = this.getCurrentState();
                if (!Comparing.haveEqualElements((Collection)original.keySet(), (Collection)current.keySet())) {
                    return true;
                }
                for (String contentEntryUrl : original.keySet()) {
                    if (Comparing.haveEqualElements((Collection)original.get((Object)contentEntryUrl), (Collection)current.get((Object)contentEntryUrl))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected MyContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
            return new MyContentEntryEditor(contentEntryUrl, this.getEditHandlers());
        }

        protected class MyContentEntryEditor
        extends ContentEntryEditor {
            private final EventDispatcher<ChangeListener> myEventDispatcher;

            public MyContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> handlers) {
                super(contentEntryUrl, handlers);
                this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
            }

            @Override
            protected ModifiableRootModel getModel() {
                return MyCommonContentEntriesEditor.this.getModel();
            }

            public void addListener(ChangeListener changeListener2) {
                this.myEventDispatcher.addListener((EventListener)changeListener2);
            }

            public void removeListener(ChangeListener changeListener2) {
                this.myEventDispatcher.removeListener((EventListener)changeListener2);
            }

            @Override
            protected ContentRootPanel createContentRootPane() {
                return new MyContentRootPanel();
            }

            @Override
            public void deleteContentFolder(ContentEntry contentEntry, ContentFolder folder) {
                if (folder instanceof ResourceRootFolder) {
                    this.removeResourceRoot(folder.getUrl());
                } else {
                    super.deleteContentFolder(contentEntry, folder);
                }
            }

            public void addResourceRoot(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor", "addResourceRoot"));
                }
                VirtualFilePointer root = VirtualFilePointerManager.getInstance().create(file2, MyCommonContentEntriesEditor.this.myFilePointersDisposable, MyCommonContentEntriesEditor.this.DUMMY_LISTENER);
                MyCommonContentEntriesEditor.this.myResourcesRoots.putValue((Object)this.getContentEntry(), (Object)root);
                ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
                this.update();
            }

            public void removeResourceRoot(@NotNull String url) {
                if (url == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor", "removeResourceRoot"));
                }
                VirtualFilePointer root = this.getResourceRoot(url);
                if (root != null) {
                    MyCommonContentEntriesEditor.this.myResourcesRoots.remove((Object)this.getContentEntry(), (Object)root);
                    ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
                    this.update();
                }
            }

            public boolean hasResourceRoot(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor", "hasResourceRoot"));
                }
                return this.getResourceRoot(file2.getUrl()) != null;
            }

            @Nullable
            public VirtualFilePointer getResourceRoot(@NotNull String url) {
                if (url == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor", "getResourceRoot"));
                }
                for (VirtualFilePointer filePointer : MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry())) {
                    if (!Comparing.equal((String)filePointer.getUrl(), (String)url)) continue;
                    return filePointer;
                }
                return null;
            }

            protected class MyContentRootPanel
            extends ContentRootPanel {
                public MyContentRootPanel() {
                    super(MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
                }

                @Override
                @NotNull
                protected ContentEntryImpl getContentEntry() {
                    ContentEntryImpl contentEntryImpl = (ContentEntryImpl)MyContentEntryEditor.this.getContentEntry();
                    if (contentEntryImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
                    }
                    return contentEntryImpl;
                }

                @Override
                protected void addFolderGroupComponents() {
                    super.addFolderGroupComponents();
                    if (!MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry()).isEmpty()) {
                        ArrayList<ResourceRootFolder> folders = new ArrayList<ResourceRootFolder>(MyCommonContentEntriesEditor.this.myResourcesRoots.size());
                        for (VirtualFilePointer root : MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry())) {
                            folders.add(new ResourceRootFolder(root, this.getContentEntry()));
                        }
                        JComponent sourcesComponent = this.createFolderGroupComponent(WebCoreBundle.message((String)"resource.root.path.component.title", (Object[])new Object[0]), folders.toArray(new ContentFolder[folders.size()]), RESOURCES_COLOR, null);
                        this.add((Component)sourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                    }
                }
            }
        }
    }

    private static class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener myListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                this.update();
            }
        };

        public MyContentEntryTreeEditor(Project project2, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(project2, handlers);
        }

        @Override
        public void setContentEntryEditor(ContentEntryEditor newEditor) {
            MyCommonContentEntriesEditor.MyContentEntryEditor existingEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)existingEditor, (Object)newEditor)) {
                return;
            }
            if (existingEditor != null) {
                existingEditor.removeListener(this.myListener);
            }
            if (newEditor != null) {
                ((MyCommonContentEntriesEditor.MyContentEntryEditor)newEditor).addListener(this.myListener);
            }
            super.setContentEntryEditor(newEditor);
        }

        @Override
        public MyCommonContentEntriesEditor.MyContentEntryEditor getContentEntryEditor() {
            return (MyCommonContentEntriesEditor.MyContentEntryEditor)super.getContentEntryEditor();
        }

        @Override
        protected void createEditingActions() {
            super.createEditingActions();
            ContentEntryEditingAction a = new ContentEntryEditingAction((JTree)this.myTree){
                {
                    super(x0);
                    Presentation templatePresentation = this.getTemplatePresentation();
                    templatePresentation.setText(WebCoreBundle.message((String)"resource.root.action.title", (Object[])new Object[0]));
                    templatePresentation.setDescription(WebCoreBundle.message((String)"resource.root.action.description", (Object[])new Object[0]));
                    templatePresentation.setIcon(ResourceRootIconProvider.RESOURCE_ROOT_ICON);
                }

                public boolean isSelected(AnActionEvent e2) {
                    VirtualFile[] selectedFiles = this.getSelectedFiles();
                    return selectedFiles.length != 0 && this.getContentEntryEditor().hasResourceRoot(selectedFiles[0]);
                }

                public void setSelected(AnActionEvent e2, boolean isSelected) {
                    VirtualFile[] selectedFiles = this.getSelectedFiles();
                    assert (selectedFiles.length != 0);
                    for (VirtualFile selectedFile : selectedFiles) {
                        boolean wasSelected = this.getContentEntryEditor().hasResourceRoot(selectedFile);
                        if (isSelected) {
                            if (wasSelected) continue;
                            this.getContentEntryEditor().addResourceRoot(selectedFile);
                            continue;
                        }
                        if (!wasSelected) continue;
                        this.getContentEntryEditor().removeResourceRoot(selectedFile.getUrl());
                    }
                }
            };
            this.myEditingActionsGroup.add((AnAction)a);
            a.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8)), (JComponent)this.myTree);
        }

        @Override
        protected TreeCellRenderer getContentEntryCellRenderer() {
            return new ContentEntryTreeCellRenderer(this, this.getEditHandlers()){

                @Override
                protected Icon updateIcon(ContentEntry entry, VirtualFile file2, Icon originalIcon) {
                    if (this.getContentEntryEditor().hasResourceRoot(file2)) {
                        return ResourceRootIconProvider.RESOURCE_ROOT_ICON;
                    }
                    return super.updateIcon(entry, file2, originalIcon);
                }
            };
        }
    }
}

