/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/webcore/resourceRoots/WebIdeWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/PrefixlessWebServerRootsProvider;", "()V", "checkWebIdeResourcesPathsConfiguration", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getPathInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "resolve", "webide-impl"})
public final class WebIdeWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    @Override
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2, @NotNull FileResolver resolver, @NotNull PathQuery pathQuery) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        return this.isApplicable() ? this.checkWebIdeResourcesPathsConfiguration(path, project2, resolver, pathQuery) : null;
    }

    private final boolean isApplicable() {
        return PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Object v3;
        Object object;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            if (!this.isApplicable()) {
                return null;
            }
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project2);
            object = webResourcesPathsConfiguration;
            if (webResourcesPathsConfiguration == null) return null;
            List<VirtualFile> list2 = ((WebResourcesPathsConfiguration)object).getResourceDirectories();
            object = list2;
            if (list2 == null) return null;
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                if (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file2, (boolean)true)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        VirtualFile virtualFile = v3;
        object = virtualFile;
        if (virtualFile == null) return null;
        Object object2 = object;
        VirtualFile it = (VirtualFile)object2;
        PathInfo pathInfo = new PathInfo(null, file2, it, null, false, false, 56, null);
        return pathInfo;
    }

    private final PathInfo checkWebIdeResourcesPathsConfiguration(String path, Project project2, FileResolver resolver, PathQuery pathQuery) {
        WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project2);
        if (webResourcesPathsConfiguration == null) {
            return null;
        }
        WebResourcesPathsConfiguration configuration = webResourcesPathsConfiguration;
        Iterator<VirtualFile> iterator2 = configuration.getResourceDirectories().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root;
            VirtualFile virtualFile = root = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
            PathInfo pathInfo = FileResolver.DefaultImpls.resolve$default(resolver, path, virtualFile, null, false, pathQuery, 12, null);
            if (pathInfo == null) {
                continue;
            }
            PathInfo result2 = pathInfo;
            return result2;
        }
        return null;
    }
}

