/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebResourceFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @Nullable
    public PsiFileSystemItem findRoot(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "findRoot"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "findRoot"));
        }
        if (WebResourceFileReferenceHelper.getWebResourceDirectories(project2).isEmpty()) {
            return null;
        }
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)project2).getContentRootForFile(file2);
        return contentRoot != null ? PsiManager.getInstance((Project)project2).findDirectory(contentRoot) : null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getRoots"));
        }
        List<VirtualFile> directories = WebResourceFileReferenceHelper.getWebResourceDirectories(module2.getProject());
        if (directories.isEmpty()) {
            Set<PsiFileSystemItem> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getRoots"));
            }
            return set2;
        }
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>(ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots(), virtualFile -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "lambda$getRoots$0"));
            }
            return PsiManager.getInstance((Project)module2.getProject()).findDirectory(virtualFile);
        }));
        for (VirtualFile directory : directories) {
            ContainerUtilRt.addIfNotNull(result2, (Object)PsiManager.getInstance((Project)module2.getProject()).findDirectory(directory));
        }
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getRoots"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getContexts"));
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance(project2);
        if (pathsConfiguration == null) {
            Set<PsiFileSystemItem> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getContexts"));
            }
            return set2;
        }
        List<VirtualFile> directories = pathsConfiguration.getResourceDirectories();
        if (directories.isEmpty()) {
            Set<PsiFileSystemItem> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getContexts"));
            }
            return set3;
        }
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>(directories.size());
        for (VirtualFile directory : directories) {
            ContainerUtilRt.addIfNotNull(result2, (Object)PsiManager.getInstance((Project)project2).findDirectory(directory));
        }
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getContexts"));
        }
        return arrayList;
    }

    @Override
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "isMine"));
        }
        return ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2);
    }

    @NotNull
    private static List<VirtualFile> getWebResourceDirectories(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getWebResourceDirectories"));
        }
        WebResourcesPathsConfiguration configuration = WebResourcesPathsConfiguration.getInstance(project2);
        List<Object> list2 = configuration != null ? configuration.getResourceDirectories() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper", "getWebResourceDirectories"));
        }
        return list2;
    }
}

