/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WebResourcesPaths", storages={@Storage(value="webResources.xml")})
public class WebResourcesPathsConfiguration
implements PersistentStateComponent<State> {
    private State myState;
    private final Project myProject;

    public WebResourcesPathsConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/resourceRoots/WebResourcesPathsConfiguration", "<init>"));
        }
        this.myState = new State();
        this.myProject = project2;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.loadResourceRoots("idea_temp_RemoteResourceRootsList");
            this.loadResourceRoots("idea_temp_LocalResourceRootsList");
        }, this.myProject.getDisposed());
    }

    private void loadResourceRoots(String fileName) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return;
        }
        final VirtualFile resourceRootsFile = baseDir.findChild(fileName);
        if (resourceRootsFile != null) {
            try {
                String text2 = VfsUtilCore.loadText((VirtualFile)resourceRootsFile);
                List<String> paths = Arrays.asList(text2.split("\n"));
                MultiMap map2 = new MultiMap();
                map2.put((Object)baseDir.getUrl(), paths);
                this.setResourceRoots((MultiMap<String, String>)map2);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resourceRootsFile.delete((Object)this);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static WebResourcesPathsConfiguration getInstance(Project project2) {
        return (WebResourcesPathsConfiguration)ServiceManager.getService((Project)project2, WebResourcesPathsConfiguration.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        VirtualFile[] contentRoots;
        this.myState = state;
        if (this.myState.myResourceRoots != null && !this.myState.myResourceRoots.isEmpty() && (contentRoots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).length == 1) {
            ContentEntryData data = new ContentEntryData();
            data.resourceRoots.addAll(this.myState.myResourceRoots);
            this.myState.contentEntries.put(contentRoots[0].getUrl(), data);
        }
        assert (this.myState.myResourceRoots != null);
        this.myState.myResourceRoots.clear();
    }

    @NotNull
    public List<VirtualFile> getResourceDirectories() {
        Map<String, ContentEntryData> contentEntries = this.myState.contentEntries;
        if (contentEntries.isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourcesPathsConfiguration", "getResourceDirectories"));
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        for (ContentEntryData entry : contentEntries.values()) {
            for (String root : entry.resourceRoots) {
                ContainerUtilRt.addIfNotNull((Collection)result2, (Object)VfsUtilCore.findRelativeFile((String)root, null));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebResourcesPathsConfiguration", "getResourceDirectories"));
        }
        return smartList;
    }

    public boolean hasResourceRootPath(String path) {
        Map<String, ContentEntryData> contentEntries = this.myState.contentEntries;
        if (contentEntries.isEmpty()) {
            return false;
        }
        for (ContentEntryData entry : contentEntries.values()) {
            if (!entry.resourceRoots.contains(path)) continue;
            return true;
        }
        return false;
    }

    public MultiMap<String, String> getResourceRoots() {
        MultiMap result2 = new MultiMap();
        for (Map.Entry<String, ContentEntryData> entry : this.myState.contentEntries.entrySet()) {
            result2.put((Object)entry.getKey(), entry.getValue().resourceRoots);
        }
        return result2;
    }

    public void setResourceRoots(MultiMap<String, String> roots) {
        this.myState.contentEntries.clear();
        for (String contentEntryUrl : roots.keySet()) {
            ContentEntryData data = new ContentEntryData();
            data.resourceRoots.addAll(roots.get((Object)contentEntryUrl));
            this.myState.contentEntries.put(contentEntryUrl, data);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            ModuleRootEventImpl event = new ModuleRootEventImpl(this.myProject, false);
            ModuleRootListener publisher = (ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS);
            publisher.beforeRootsChange((ModuleRootEvent)event);
            publisher.rootsChanged((ModuleRootEvent)event);
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public static class State {
        @Tag(value="resourceRoots")
        @AbstractCollection(surroundWithTag=false, elementTag="path")
        public List<String> myResourceRoots = new SmartList();
        @Tag(value="contentEntries")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, keyAttributeName="url", surroundValueWithTag=false, entryTagName="entry")
        public Map<String, ContentEntryData> contentEntries = new HashMap<String, ContentEntryData>();
    }

    @Tag(value="entryData")
    public static class ContentEntryData {
        @Tag(value="resourceRoots")
        @AbstractCollection(surroundWithTag=false, elementTag="path")
        public List<String> resourceRoots = new SmartList();
    }
}

