/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.template;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.template.TemplateLanguageFileUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTemplateLanguageFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private Language myTemplateDataLanguage;
    private final Set<Language> myLanguages;

    public AbstractTemplateLanguageFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, TemplateLanguageFileUtil.getTemplateDataLanguage(manager.getProject(), virtualFile));
    }

    protected AbstractTemplateLanguageFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language templateDataLanguage) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "<init>"));
        }
        if (templateDataLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateDataLanguage", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "<init>"));
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myLanguages = new HashSet<Language>();
        this.myTemplateDataLanguage = templateDataLanguage;
        this.myLanguages.add(this.getBaseLanguage());
        this.myLanguages.add(this.myTemplateDataLanguage);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set2 = this.myLanguages;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "getLanguages"));
        }
        return set2;
    }

    protected abstract IElementType getTemplateDataType();

    @Override
    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider", "createFile"));
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file2 = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file2.setContentElementType(this.getTemplateDataType());
            return file2;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }
}

