/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.template;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.annotations.NotNull;

public class TemplateLanguageFileUtil {
    private TemplateLanguageFileUtil() {
    }

    @NotNull
    public static Language getTemplateDataLanguage(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguage"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguage"));
        }
        Language language = TemplateDataLanguageMappings.getInstance(project2).getMapping(virtualFile);
        if (language == null) {
            language = TemplateLanguageFileUtil.getTemplateDataLanguageByExtension(virtualFile, project2);
        }
        Language language2 = language;
        if (language2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguage"));
        }
        return language2;
    }

    @NotNull
    private static Language getTemplateDataLanguageByExtension(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Language language;
        FileType fileType;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguageByExtension"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguageByExtension"));
        }
        String templateExt = virtualFile.getName();
        int dotOffset = templateExt.lastIndexOf(46);
        if (dotOffset >= 0 && (dotOffset = (templateExt = templateExt.substring(0, dotOffset)).lastIndexOf(46)) >= 0 && dotOffset + 1 < templateExt.length() && !(templateExt = templateExt.substring(dotOffset + 1)).isEmpty() && (fileType = FileTypeManager.getInstance().getFileTypeByExtension(templateExt)) instanceof LanguageFileType && !((language = ((LanguageFileType)fileType).getLanguage()) instanceof TemplateLanguage)) {
            for (LanguageSubstitutor substitutor : LanguageSubstitutors.INSTANCE.forKey((Object)language)) {
                Language substLang = substitutor.getLanguage(virtualFile, project2);
                if (substLang == null || substLang instanceof TemplateLanguage) continue;
                Language language2 = substLang;
                if (language2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguageByExtension"));
                }
                return language2;
            }
            Language language3 = language;
            if (language3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguageByExtension"));
            }
            return language3;
        }
        Language language4 = StdLanguages.HTML;
        if (language4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/TemplateLanguageFileUtil", "getTemplateDataLanguageByExtension"));
        }
        return language4;
    }
}

