/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeTemplateBlock
implements Block {
    private final List<Block> mySubBlocks;
    private final TextRange myTextRange;

    public CompositeTemplateBlock(List<Block> subBlocks) {
        this.mySubBlocks = subBlocks;
        this.myTextRange = new TextRange(this.mySubBlocks.get(0).getTextRange().getStartOffset(), this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/formatter/CompositeTemplateBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list2 = this.mySubBlocks;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/formatter/CompositeTemplateBlock", "getSubBlocks"));
        }
        return list2;
    }

    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return Indent.getNoneIndent();
    }

    public Alignment getAlignment() {
        return null;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/webcore/template/formatter/CompositeTemplateBlock", "getSpacing"));
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/template/formatter/CompositeTemplateBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }
}

