/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.ui;

import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final Map<Component, DoublyLinkedNode> myNodeByComponentMap;
    private final Container myContainer;
    private int myOrderCount;
    private Component myFirstComponent;
    private Component myLastComponent;
    private Component myPreviouslyAddedComponent;

    private CustomFocusTraversalPolicy(@NotNull Container container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "<init>"));
        }
        this.myNodeByComponentMap = ContainerUtil.newIdentityHashMap();
        this.myOrderCount = 0;
        this.myContainer = container;
    }

    public void addNextComponentInTraversalOrder(@NotNull Component nextComponent) {
        if (nextComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextComponent", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "addNextComponentInTraversalOrder"));
        }
        DoublyLinkedNode nextNode = this.getDoublyLinkedNode(nextComponent);
        if (this.myPreviouslyAddedComponent != null) {
            ++this.myOrderCount;
            DoublyLinkedNode prevNode = this.getDoublyLinkedNode(this.myPreviouslyAddedComponent);
            prevNode.setNextValue(nextNode);
        }
        this.myPreviouslyAddedComponent = nextComponent;
        this.myFirstComponent = null;
        this.myLastComponent = null;
    }

    @NotNull
    private DoublyLinkedNode getDoublyLinkedNode(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "getDoublyLinkedNode"));
        }
        DoublyLinkedNode node = this.myNodeByComponentMap.get(component);
        if (node == null) {
            node = new DoublyLinkedNode(component);
            this.myNodeByComponentMap.put(component, node);
        }
        DoublyLinkedNode doublyLinkedNode = node;
        if (doublyLinkedNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "getDoublyLinkedNode"));
        }
        return doublyLinkedNode;
    }

    private boolean isValid(Container aContainer) {
        boolean valid;
        boolean bl = valid = this.myOrderCount == 0 && this.myNodeByComponentMap.size() == 0 || this.myOrderCount == 1 && this.myNodeByComponentMap.size() == 1 || this.myNodeByComponentMap.size() == this.myOrderCount + 1;
        if (!valid) {
            throw new RuntimeException("Traversal order is not a list");
        }
        return aContainer == this.myContainer;
    }

    @Override
    @Nullable
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        DoublyLinkedNode node;
        Component after2 = null;
        if (this.isValid(aContainer) && (node = this.myNodeByComponentMap.get(aComponent)) != null) {
            after2 = node.getNextComponent();
        }
        return after2;
    }

    @Override
    @Nullable
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        DoublyLinkedNode node;
        Component before = null;
        if (this.isValid(aContainer) && (node = this.myNodeByComponentMap.get(aComponent)) != null) {
            before = node.getPrevComponent();
        }
        return before;
    }

    @Override
    @Nullable
    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    @Override
    @Nullable
    public Component getLastComponent(Container aContainer) {
        Component last = null;
        if (this.isValid(aContainer)) {
            DoublyLinkedNode anyNode;
            if (this.myLastComponent == null && (anyNode = this.getAnyNode()) != null) {
                this.myLastComponent = anyNode.getLastValue();
            }
            last = this.myLastComponent;
        }
        return last;
    }

    @Override
    @Nullable
    public Component getFirstComponent(Container aContainer) {
        Component first = null;
        if (this.isValid(aContainer)) {
            DoublyLinkedNode anyNode;
            if (this.myFirstComponent == null && (anyNode = this.getAnyNode()) != null) {
                this.myFirstComponent = anyNode.getFirstValue();
            }
            first = this.myFirstComponent;
        }
        return first;
    }

    @Nullable
    private DoublyLinkedNode getAnyNode() {
        Iterator<DoublyLinkedNode> iterator2 = this.myNodeByComponentMap.values().iterator();
        if (iterator2.hasNext()) {
            return iterator2.next();
        }
        return null;
    }

    @NotNull
    public static CustomFocusTraversalPolicy createAndInstallOn(@NotNull Container container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "createAndInstallOn"));
        }
        CustomFocusTraversalPolicy customFocusTraversalPolicy = new CustomFocusTraversalPolicy(container);
        container.setFocusTraversalPolicyProvider(true);
        container.setFocusTraversalPolicy(customFocusTraversalPolicy);
        CustomFocusTraversalPolicy customFocusTraversalPolicy2 = customFocusTraversalPolicy;
        if (customFocusTraversalPolicy2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/ui/CustomFocusTraversalPolicy", "createAndInstallOn"));
        }
        return customFocusTraversalPolicy2;
    }

    private static class DoublyLinkedNode {
        private final Component myComponent;
        private DoublyLinkedNode myPrevNode;
        private DoublyLinkedNode myNextNode;

        private DoublyLinkedNode(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode", "<init>"));
            }
            this.myComponent = component;
        }

        public void setNextValue(@NotNull DoublyLinkedNode nextNode) {
            if (nextNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextNode", "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode", "setNextValue"));
            }
            if (this.myNextNode != null) {
                throw new RuntimeException("Next value has been already specified");
            }
            if (nextNode.myPrevNode != null) {
                throw new RuntimeException("Previous value has been already specified");
            }
            this.myNextNode = nextNode;
            nextNode.myPrevNode = this;
        }

        @NotNull
        public Component getFirstValue() {
            DoublyLinkedNode node = this;
            while (node.myPrevNode != null) {
                node = node.myPrevNode;
            }
            Component component = node.myComponent;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode", "getFirstValue"));
            }
            return component;
        }

        @NotNull
        public Component getLastValue() {
            DoublyLinkedNode node = this;
            while (node.myNextNode != null) {
                node = node.myNextNode;
            }
            Component component = node.myComponent;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode", "getLastValue"));
            }
            return component;
        }

        @Nullable
        public Component getPrevComponent() {
            return this.myPrevNode != null ? this.myPrevNode.myComponent : null;
        }

        @Nullable
        public Component getNextComponent() {
            return this.myNextNode != null ? this.myNextNode.myComponent : null;
        }
    }
}

