/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineUtil {
    private static final Logger LOG = Logger.getInstance(CommandLineUtil.class);

    private CommandLineUtil() {
    }

    public static void configureShellEnvironment(@NotNull GeneralCommandLine commandLine, boolean passParentEnvironment, @NotNull Map<String, String> userEnvironment) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/webcore/util/CommandLineUtil", "configureShellEnvironment"));
        }
        if (userEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userEnvironment", "com/intellij/webcore/util/CommandLineUtil", "configureShellEnvironment"));
        }
        commandLine.withParentEnvironmentType(passParentEnvironment ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.withEnvironment(userEnvironment);
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)commandLine);
    }

    public static void setWorkingDirectory(@NotNull GeneralCommandLine commandLine, @Nullable File workingDir, boolean driveLetterToLowerCase) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/webcore/util/CommandLineUtil", "setWorkingDirectory"));
        }
        if (workingDir != null && workingDir.isDirectory()) {
            if (SystemInfo.isWindows && driveLetterToLowerCase) {
                String path = workingDir.getAbsolutePath();
                workingDir = new File(PathUtil.driveLetterToLowerCase((String)path));
            }
            commandLine.withWorkDirectory(workingDir);
        } else if (workingDir != null) {
            LOG.warn("Cannot set working directory: " + workingDir.getAbsolutePath() + " is not a directory");
        } else {
            LOG.warn("Cannot set working directory: no working directory specified");
        }
    }

    public static void setWorkingDirectoryAndPWD(@NotNull GeneralCommandLine commandLine, @NotNull String workingDirectory) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/webcore/util/CommandLineUtil", "setWorkingDirectoryAndPWD"));
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/intellij/webcore/util/CommandLineUtil", "setWorkingDirectoryAndPWD"));
        }
        CommandLineUtil.setWorkingDirectoryAndPwd(commandLine, workingDirectory);
    }

    public static void setWorkingDirectoryAndPwd(@NotNull GeneralCommandLine commandLine, @NotNull String workingDirectory) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/webcore/util/CommandLineUtil", "setWorkingDirectoryAndPwd"));
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/intellij/webcore/util/CommandLineUtil", "setWorkingDirectoryAndPwd"));
        }
        String cwd = FileUtil.toSystemDependentName((String)workingDirectory);
        commandLine.withWorkDirectory(cwd);
        if (SystemInfo.isUnix) {
            String name = "PWD";
            Map environment = commandLine.getEnvironment();
            if (!environment.containsKey(name)) {
                environment.put(name, cwd);
            }
        }
    }
}

