/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String content2) {
        try {
            return JsonUtil.parseJsonObject(content2);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsonObject parseJsonObject(@Nullable String content2) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)content2)));
        jsonReader.setLenient(true);
        JsonElement element = new JsonParser().parse(jsonReader);
        JsonObject jsonObject = element.getAsJsonObject();
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "parseJsonObject"));
        }
        return jsonObject2;
        finally {
            try {
                jsonReader.close();
            }
            catch (Exception exception) {}
        }
    }

    @NotNull
    public static List<Object> nextList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "nextList"));
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextList"));
            }
            return list2;
        }
        ArrayList<Object> list3 = new ArrayList<Object>(2);
        while (reader.hasNext()) {
            list3.add(JsonUtil.nextAny(reader));
        }
        reader.endArray();
        ArrayList<Object> arrayList = list3;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextList"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> nextStringList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "nextStringList"));
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextStringList"));
            }
            return list2;
        }
        ArrayList list3 = ContainerUtil.newArrayListWithCapacity((int)2);
        while (reader.hasNext()) {
            String value2 = JsonUtil.nextStringOrSkip(reader);
            if (value2 == null) continue;
            list3.add(value2);
        }
        reader.endArray();
        ArrayList arrayList = list3;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextStringList"));
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, Object> nextMap(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "nextMap"));
        }
        reader.beginObject();
        if (!reader.hasNext()) {
            reader.endObject();
            Map<String, Object> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextMap"));
            }
            return map2;
        }
        HashMap<String, Object> map3 = new HashMap<String, Object>(2);
        while (reader.hasNext()) {
            map3.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        HashMap<String, Object> hashMap = map3;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "nextMap"));
        }
        return hashMap;
    }

    @Nullable
    public static String nextStringOrSkip(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "nextStringOrSkip"));
        }
        JsonToken token = reader.peek();
        if (token == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return null;
    }

    @Nullable
    public static Object nextAny(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "nextAny"));
        }
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextMap(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Deprecated
    @Nullable
    public static String getString(@NotNull JsonObject object, @NotNull String key) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/webcore/util/JsonUtil", "getString"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/webcore/util/JsonUtil", "getString"));
        }
        return JsonUtil.getChildAsString(object, key);
    }

    @Nullable
    public static String getChildAsString(@Nullable JsonObject object, @NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/webcore/util/JsonUtil", "getChildAsString"));
        }
        JsonElement childElement = object != null ? object.get(key) : null;
        return JsonUtil.getString(childElement);
    }

    @Nullable
    public static JsonArray getChildAsArray(@Nullable JsonObject object, @NotNull String memberName) {
        JsonElement childElement;
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsArray"));
        }
        JsonElement jsonElement = childElement = object != null ? object.get(memberName) : null;
        if (childElement != null && childElement.isJsonArray()) {
            return childElement.getAsJsonArray();
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsStringList(@Nullable JsonObject object, @NotNull String memberName) {
        JsonElement childElement;
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsStringList"));
        }
        JsonElement jsonElement = childElement = object != null ? object.get(memberName) : null;
        if (childElement != null && childElement.isJsonArray()) {
            JsonArray array2 = childElement.getAsJsonArray();
            ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)array2.size());
            for (JsonElement element : array2) {
                String value2 = JsonUtil.getString(element);
                if (value2 == null) continue;
                list2.add(value2);
            }
            return list2;
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsSingleStringOrList(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsSingleStringOrList"));
        }
        JsonElement childElement = object != null ? object.get(memberName) : null;
        String singleString = JsonUtil.getString(childElement);
        return singleString != null ? ContainerUtil.list((Object[])new String[]{singleString}) : JsonUtil.getChildAsStringList(object, memberName);
    }

    @Nullable
    public static JsonObject getChildAsObject(@Nullable JsonObject object, @NotNull String memberName) {
        JsonElement childElement;
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsObject"));
        }
        JsonElement jsonElement = childElement = object != null ? object.get(memberName) : null;
        if (childElement != null && childElement.isJsonObject()) {
            return childElement.getAsJsonObject();
        }
        return null;
    }

    @Nullable
    public static Boolean getChildAsBooleanObj(@Nullable JsonObject object, @NotNull String memberName) {
        JsonPrimitive primitive;
        JsonElement childElement;
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsBooleanObj"));
        }
        JsonElement jsonElement = childElement = object != null ? object.get(memberName) : null;
        if (childElement != null && childElement.isJsonPrimitive() && (primitive = childElement.getAsJsonPrimitive()).isBoolean()) {
            return primitive.getAsBoolean();
        }
        return null;
    }

    public static boolean getChildAsBoolean(@Nullable JsonObject object, @NotNull String memberName, boolean defaultValue) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsBoolean"));
        }
        return (Boolean)ObjectUtils.notNull((Object)JsonUtil.getChildAsBooleanObj(object, memberName), (Object)defaultValue);
    }

    @Nullable
    public static String getString(@Nullable JsonElement element) {
        JsonPrimitive primitive;
        if (element != null && element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return primitive.getAsString();
        }
        return null;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "getChildAsString"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsString"));
        }
        return JsonUtil.getChildAsString(reader, memberName, null);
    }

    @NotNull
    public static Map<String, String> getTopLevelStringValues(@NotNull JsonReader reader, @NotNull Set<String> names) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "getTopLevelStringValues"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/webcore/util/JsonUtil", "getTopLevelStringValues"));
        }
        JsonToken token = reader.peek();
        if (token != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "getTopLevelStringValues"));
            }
            return map2;
        }
        reader.beginObject();
        HashMap<String, String> map3 = new HashMap<String, String>(names.size(), 1.0f);
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (names.contains(key)) {
                String value2 = JsonUtil.nextStringOrSkip(reader);
                if (value2 == null) continue;
                map3.put(key, value2);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        HashMap<String, String> hashMap = map3;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/JsonUtil", "getTopLevelStringValues"));
        }
        return hashMap;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName, @Nullable String failoverMemberName) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/util/JsonUtil", "getChildAsString"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/intellij/webcore/util/JsonUtil", "getChildAsString"));
        }
        Set names = failoverMemberName == null ? Collections.singleton(memberName) : ContainerUtil.set((Object[])new String[]{memberName, failoverMemberName});
        Map<String, String> values = JsonUtil.getTopLevelStringValues(reader, names);
        String value2 = values.get(memberName);
        return value2 != null ? value2 : values.get(failoverMemberName);
    }

    public static int getChildAsInteger(@Nullable JsonObject object, @NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/webcore/util/JsonUtil", "getChildAsInteger"));
        }
        JsonElement childElement = object != null ? object.get(key) : null;
        return JsonUtil.getInteger(childElement, defaultValue);
    }

    private static int getInteger(@Nullable JsonElement element, int defaultValue) {
        if (element instanceof JsonPrimitive && ((JsonPrimitive)element).isNumber()) {
            return element.getAsInt();
        }
        return defaultValue;
    }
}

