/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputCatcher {
    private static final Logger LOG = Logger.getInstance(ProcessOutputCatcher.class);
    private static final long WAIT_TIMEOUT_MILLIS = 100L;
    private static final long SOFT_AND_HARD_KILLS_TIMEOUT_MILLIS = 5000L;
    private static final long WAIT_TIMEOUT_AFTER_TERMINATION_MILLIS = 10000L;
    private final BaseOSProcessHandler myProcessHandler;
    private final ProcessOutput myOutput;

    public ProcessOutputCatcher(@NotNull BaseOSProcessHandler processHandler2) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/webcore/util/ProcessOutputCatcher", "<init>"));
        }
        this.myProcessHandler = processHandler2;
        this.myOutput = new ProcessOutput();
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDERR) {
                    ProcessOutputCatcher.this.myOutput.appendStderr(event.getText());
                } else if (outputType != ProcessOutputTypes.SYSTEM) {
                    ProcessOutputCatcher.this.myOutput.appendStdout(event.getText());
                }
            }
        });
    }

    @NotNull
    public ProcessOutput getOutput() {
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/ProcessOutputCatcher", "getOutput"));
        }
        return processOutput;
    }

    public void startNotify() {
        this.myProcessHandler.startNotify();
    }

    public boolean run(long millis) {
        if (this.myProcessHandler.waitFor(millis)) {
            return this.setExitCode();
        }
        return false;
    }

    public void run() {
        if (this.myProcessHandler.waitFor()) {
            this.setExitCode();
        } else {
            LOG.warn("Process is still alive");
        }
    }

    @NotNull
    public ProcessOutput run(@Nullable ProgressIndicator indicator, long timeoutMillis) throws ExecutionException {
        this.myProcessHandler.startNotify();
        long startMillis = System.currentTimeMillis();
        while (!this.myProcessHandler.waitFor(100L)) {
            boolean canceled;
            long runningTime = System.currentTimeMillis() - startMillis;
            boolean bl = canceled = indicator != null && indicator.isCanceled();
            if (!canceled && runningTime < timeoutMillis) continue;
            if (canceled) {
                this.myOutput.setCancelled();
            } else {
                this.myOutput.setTimeout();
            }
            if (this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) break;
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, 5000L, this.myProcessHandler.getCommandLine());
            break;
        }
        if (!this.myProcessHandler.waitFor(10000L)) {
            throw new ExecutionException("Cannot terminate command " + this.getProcessInfo());
        }
        this.setExitCode();
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/ProcessOutputCatcher", "run"));
        }
        return processOutput;
    }

    private boolean setExitCode() {
        try {
            this.myOutput.setExitCode(this.myProcessHandler.getProcess().exitValue());
            return true;
        }
        catch (IllegalThreadStateException e2) {
            LOG.warn("Process has not terminated yet " + this.getProcessInfo());
            return false;
        }
    }

    public void terminateAndWait() {
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, 5000L, null);
        if (!this.myProcessHandler.waitFor(10000L)) {
            LOG.warn("Cannot terminate " + this.getProcessInfo());
        }
    }

    @NotNull
    private String getProcessInfo() {
        String string2 = "(" + this.myProcessHandler.getCommandLine() + ", class " + this.myProcessHandler.getProcess().getClass().getName() + ")";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/util/ProcessOutputCatcher", "getProcessInfo"));
        }
        return string2;
    }
}

