/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import org.jetbrains.annotations.NotNull;

public class MuteBreakpointAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
                DebuggerToggleActionHandler handler2 = support.getMuteBreakpointsHandler();
                if (!handler2.isEnabled(project2, e2)) continue;
                return handler2.isSelected(project2, e2);
            }
        }
        return false;
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
                DebuggerToggleActionHandler handler2 = support.getMuteBreakpointsHandler();
                if (!handler2.isEnabled(project2, e2)) continue;
                handler2.setSelected(project2, e2, state);
                return;
            }
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/actions/MuteBreakpointAction", "update"));
        }
        super.update(e2);
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
                DebuggerToggleActionHandler handler2 = support.getMuteBreakpointsHandler();
                if (!handler2.isEnabled(project2, e2)) continue;
                e2.getPresentation().setEnabled(true);
                return;
            }
        }
        e2.getPresentation().setEnabled(false);
    }

    public boolean isDumbAware() {
        return Registry.is((String)"dumb.aware.run.configurations");
    }
}

