/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.actions.ChooseDebugConfigurationPopupAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class ResumeAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    protected boolean isEnabled(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 == null) {
            return false;
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session2 != null && !session2.isStopped()) {
            return session2.isPaused();
        }
        return e2.getInputEvent() instanceof KeyEvent;
    }

    @Override
    public void actionPerformed(AnActionEvent e2) {
        Project project2;
        if (!this.performWithHandler(e2) && (project2 = ResumeAction.getEventProject((AnActionEvent)e2)) != null && !DumbService.isDumb((Project)project2)) {
            new ChooseDebugConfigurationPopupAction().actionPerformed(e2);
        }
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        DebuggerActionHandler debuggerActionHandler = debuggerSupport.getResumeActionHandler();
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        return debuggerActionHandler;
    }
}

