/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import org.jetbrains.annotations.NotNull;

final class ShowLibraryFramesAction
extends ToggleAction {
    private static final String IS_LIBRARY_FRAME_FILTER_SUPPORTED = "isLibraryFrameFilterSupported";
    private volatile boolean myShouldShow = XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowLibraryStackFrames();
    private static final String ourTextWhenShowIsOn = "Hide Frames from Libraries";
    private static final String ourTextWhenShowIsOff = "Show All Frames";

    public ShowLibraryFramesAction() {
        super("", "", AllIcons.Debugger.Class_filter);
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/actions/ShowLibraryFramesAction", "update"));
        }
        super.update(e2);
        Presentation presentation = e2.getPresentation();
        Object isSupported = presentation.getClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED);
        XDebugSession session2 = (XDebugSession)e2.getData(XDebugSession.DATA_KEY);
        if (isSupported == null) {
            if (session2 == null) {
                presentation.setVisible(false);
                return;
            }
            isSupported = session2.getDebugProcess().isLibraryFrameFilterSupported();
            presentation.putClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED, isSupported);
        }
        if (Boolean.TRUE.equals(isSupported)) {
            presentation.setVisible(true);
            boolean shouldShow = !Boolean.TRUE.equals(presentation.getClientProperty("selected"));
            presentation.setText(shouldShow ? ourTextWhenShowIsOn : ourTextWhenShowIsOff);
        } else {
            presentation.setVisible(false);
        }
    }

    public boolean isSelected(AnActionEvent e2) {
        return !this.myShouldShow;
    }

    public void setSelected(AnActionEvent e2, boolean enabled) {
        this.myShouldShow = !enabled;
        XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(this.myShouldShow);
        XDebuggerUtilImpl.rebuildAllSessionsViews(e2.getProject());
    }
}

