/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ToggleBreakpointEnabledAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        Set<XLineBreakpoint> breakpoints = ToggleBreakpointEnabledAction.findLineBreakpoints(e2);
        Iterator iterator2 = breakpoints.iterator();
        while (iterator2.hasNext()) {
            XLineBreakpoint breakpoint;
            breakpoint.setEnabled(!(breakpoint = (XLineBreakpoint)iterator2.next()).isEnabled());
        }
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(!ToggleBreakpointEnabledAction.findLineBreakpoints(e2).isEmpty());
    }

    @NotNull
    private static Set<XLineBreakpoint> findLineBreakpoints(AnActionEvent e2) {
        Project project2 = e2.getProject();
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (project2 == null || editor == null) {
            Set<XLineBreakpoint> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction", "findLineBreakpoints"));
            }
            return set2;
        }
        XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = editor.getDocument();
        ArrayList<Range> lineRanges = new ArrayList<Range>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            lineRanges.add(new Range((Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionStart())), (Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionEnd()))));
        }
        Collection<XLineBreakpointImpl> breakpoints = lineBreakpointManager.getDocumentBreakpoints(document);
        HashSet res2 = new HashSet();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            int line = breakpoint.getLine();
            for (Range range : lineRanges) {
                if (!range.isWithin((Comparable)Integer.valueOf(line))) continue;
                res2.add((Object)breakpoint);
            }
        }
        HashSet hashSet = res2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction", "findLineBreakpoints"));
        }
        return hashSet;
    }
}

