/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class XDebuggerActionBase
extends AnAction
implements AnAction.TransparentUpdate {
    private final boolean myHideDisabledInPopup;

    protected XDebuggerActionBase() {
        this(false);
    }

    protected XDebuggerActionBase(boolean hideDisabledInPopup) {
        this.myHideDisabledInPopup = hideDisabledInPopup;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        boolean hidden = this.isHidden(event);
        if (hidden) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = this.isEnabled(event);
        if (this.myHideDisabledInPopup && ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setEnabled(enabled);
    }

    protected boolean isEnabled(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 != null && !project2.isDisposed()) {
            return Arrays.stream(DebuggerSupport.getDebuggerSupports()).anyMatch(support -> this.isEnabled(project2, e2, (DebuggerSupport)support));
        }
        return false;
    }

    @NotNull
    protected abstract DebuggerActionHandler getHandler(@NotNull DebuggerSupport var1);

    private boolean isEnabled(Project project2, AnActionEvent event, DebuggerSupport support) {
        return this.getHandler(support).isEnabled(project2, event);
    }

    public void actionPerformed(AnActionEvent e2) {
        this.performWithHandler(e2);
    }

    protected boolean performWithHandler(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 == null || project2.isDisposed()) {
            return true;
        }
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            if (!this.isEnabled(project2, e2, support)) continue;
            this.perform(project2, e2, support);
            return true;
        }
        return false;
    }

    private void perform(Project project2, AnActionEvent e2, DebuggerSupport support) {
        this.getHandler(support).perform(project2, e2);
    }

    protected boolean isHidden(AnActionEvent event) {
        Project project2 = event.getProject();
        if (project2 != null && !project2.isDisposed()) {
            return Arrays.stream(DebuggerSupport.getDebuggerSupports()).allMatch(support -> this.getHandler((DebuggerSupport)support).isHidden(project2, event));
        }
        return true;
    }

    public boolean isDumbAware() {
        return Registry.is((String)"dumb.aware.run.configurations");
    }
}

