/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        String selectedText;
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "perform"));
        }
        XDebuggerEditorsProvider editorsProvider = session2.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        XDebuggerEvaluator evaluator2 = session2.getDebugProcess().getEvaluator();
        if (evaluator2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string2 = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator2.formatTextForEvaluation(selectedText);
            mode = evaluator2.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        Promise<String> expressionTextPromise = Promise.resolve((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator2, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EvaluationMode finalMode = mode;
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(dataContext);
        expressionTextPromise.done(expressionText -> {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$perform$3"));
            }
            if (expressionText == null && value2 != null) {
                value2.calculateEvaluationExpression().done(expression -> {
                    if (session2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$1"));
                    }
                    if (expression != null) {
                        AppUIUtil.invokeOnEdt(() -> {
                            if (session2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$0"));
                            }
                            XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator2, expression);
                        });
                    }
                });
            } else {
                XExpressionImpl expression2 = XExpressionImpl.fromText(StringUtil.notNullize((String)expressionText), finalMode);
                AppUIUtil.invokeOnEdt(() -> {
                    if (session2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$2"));
                    }
                    XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator2, expression2);
                });
            }
        });
    }

    private static void showDialog(@NotNull XDebugSession session2, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator2, @NotNull XExpression expression) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression = new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
        }
        new XDebuggerEvaluationDialog(session2, editorsProvider, evaluator2, expression, stackFrame == null ? null : stackFrame.getSourcePosition()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator2, @Nullable Project project2, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (project2 == null || evaluator2 == null) {
            Promise promise2 = Promise.resolve(null);
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
            }
            return promise2;
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator2.getExpressionInfoAtOffsetAsync(project2, document, editor.getCaretModel().getOffset(), true);
        Promise promise3 = expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        return promise3;
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getExpressionText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getDisplayText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getDisplayText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "isEnabled"));
        }
        return session2.getDebugProcess().getEvaluator() != null;
    }
}

