/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.ExpandRegionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XBreakpointUtil {
    private XBreakpointUtil() {
    }

    public static <B extends XBreakpoint> String getShortText(B breakpoint) {
        return StringUtil.shortenTextWithEllipsis((String)StringUtil.notNullize((String)breakpoint.getType().getShortText(breakpoint)), (int)70, (int)5);
    }

    public static <B extends XBreakpoint> String getDisplayText(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "getDisplayText"));
        }
        return breakpoint.getType().getDisplayText(breakpoint);
    }

    @Nullable
    public static XBreakpointType<?, ?> findType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findType"));
        }
        return ((StreamEx)XBreakpointUtil.breakpointTypes().filter(breakpointType -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "lambda$findType$0"));
            }
            return id.equals(breakpointType.getId());
        })).findFirst().orElse(null);
    }

    public static StreamEx<XBreakpointType> breakpointTypes() {
        return StreamEx.of((Object[])XBreakpointType.EXTENSION_POINT_NAME.getExtensions());
    }

    @NotNull
    public static Pair<GutterIconRenderer, Object> findSelectedBreakpoint(@NotNull Project project2, @NotNull Editor editor) {
        DebuggerSupport[] debuggerSupports;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        int offset = editor.getCaretModel().getOffset();
        Document editorDocument = editor.getDocument();
        for (DebuggerSupport debuggerSupport : debuggerSupports = DebuggerSupport.getDebuggerSupports()) {
            Object breakpoint;
            BreakpointPanelProvider<?> provider = debuggerSupport.getBreakpointPanelProvider();
            int textLength = editor.getDocument().getTextLength();
            if (offset > textLength) {
                offset = textLength;
            }
            if ((breakpoint = provider.findBreakpoint(project2, editorDocument, offset)) == null) continue;
            GutterIconRenderer iconRenderer = provider.getBreakpointGutterIconRenderer(breakpoint);
            Pair pair = Pair.create((Object)iconRenderer, breakpoint);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
            }
            return pair;
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        return pair;
    }

    public static List<BreakpointPanelProvider> collectPanelProviders() {
        ArrayList<BreakpointPanelProvider> panelProviders = new ArrayList<BreakpointPanelProvider>();
        for (DebuggerSupport debuggerSupport : DebuggerSupport.getDebuggerSupports()) {
            panelProviders.add(debuggerSupport.getBreakpointPanelProvider());
        }
        panelProviders.sort((o1, o2) -> o2.getPriority() - o1.getPriority());
        return panelProviders;
    }

    @Nullable
    public static DebuggerSupport getDebuggerSupport(Project project2, BreakpointItem breakpointItem) {
        DebuggerSupport[] debuggerSupports = DebuggerSupport.getDebuggerSupports();
        ArrayList<BreakpointItem> items2 = new ArrayList<BreakpointItem>();
        for (DebuggerSupport support : debuggerSupports) {
            support.getBreakpointPanelProvider().provideBreakpointItems(project2, items2);
            if (items2.contains(breakpointItem)) {
                return support;
            }
            items2.clear();
        }
        return null;
    }

    @NotNull
    public static Promise<XLineBreakpoint> toggleLineBreakpoint(@NotNull Project project2, @NotNull XSourcePosition position, @Nullable Editor editor, boolean temporary, boolean moveCaret, boolean canRemove) {
        FoldRegion region;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "toggleLineBreakpoint"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "toggleLineBreakpoint"));
        }
        int lineStart = position.getLine();
        VirtualFile file2 = position.getFile();
        int linesEnd = lineStart;
        if (editor != null && (region = FoldingUtil.findFoldRegionStartingAtLine(editor, lineStart)) != null && !region.isExpanded()) {
            linesEnd = region.getDocument().getLineNumber(region.getEndOffset());
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        XLineBreakpointType[] lineTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XLineBreakpointType typeWinner = null;
        int lineWinner = -1;
        for (int line = lineStart; line <= linesEnd; ++line) {
            int maxPriority = 0;
            for (XLineBreakpointType type : lineTypes) {
                maxPriority = Math.max(maxPriority, type.getPriority());
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file2, line);
                if (!type.canPutAt(file2, line, project2) && breakpoint == null || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
                typeWinner = type;
                lineWinner = line;
            }
            if (typeWinner != null && typeWinner.getPriority() == maxPriority) break;
        }
        if (typeWinner != null) {
            XSourcePosition winPosition;
            Object object = winPosition = lineStart == lineWinner ? position : XSourcePositionImpl.create(file2, lineWinner);
            if (winPosition != null) {
                Promise<XLineBreakpoint> res2 = XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project2, typeWinner, winPosition, temporary, editor, canRemove);
                if (editor != null && lineStart != lineWinner) {
                    int offset = editor.getDocument().getLineStartOffset(lineWinner);
                    ExpandRegionAction.expandRegionAtOffset(project2, editor, offset);
                    if (moveCaret) {
                        editor.getCaretModel().moveToOffset(offset);
                    }
                }
                Promise<XLineBreakpoint> promise2 = res2;
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "toggleLineBreakpoint"));
                }
                return promise2;
            }
        }
        Promise promise3 = Promises.rejectedPromise();
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "toggleLineBreakpoint"));
        }
        return promise3;
    }
}

