/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XBreakpointTypeGroup
extends XBreakpointGroup {
    private final XBreakpointType myBreakpointType;

    public XBreakpointTypeGroup(XBreakpointType type) {
        this.myBreakpointType = type;
    }

    @NotNull
    public String getName() {
        String string2 = this.myBreakpointType.getTitle();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointTypeGroup", "getName"));
        }
        return string2;
    }

    public XBreakpointType getBreakpointType() {
        return this.myBreakpointType;
    }

    public Icon getIcon(boolean isOpen) {
        return this.myBreakpointType.getEnabledIcon();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(XBreakpointGroup o2) {
        if (this.getName().equals(o2.getName())) {
            return 0;
        }
        if (!(o2 instanceof XBreakpointTypeGroup)) return -o2.compareTo((XBreakpointGroup)this);
        if (((XBreakpointTypeGroup)o2).myBreakpointType instanceof XLineBreakpointType) {
            if (!(this.myBreakpointType instanceof XLineBreakpointType)) return 1;
            int res2 = ((XLineBreakpointType)((XBreakpointTypeGroup)o2).myBreakpointType).getPriority() - ((XLineBreakpointType)this.myBreakpointType).getPriority();
            if (res2 == 0) return XBreakpointTypeGroup.indexOfType(this.myBreakpointType) - XBreakpointTypeGroup.indexOfType(((XBreakpointTypeGroup)o2).getBreakpointType());
            return res2;
        }
        if (!(this.myBreakpointType instanceof XLineBreakpointType)) return XBreakpointTypeGroup.indexOfType(this.myBreakpointType) - XBreakpointTypeGroup.indexOfType(((XBreakpointTypeGroup)o2).getBreakpointType());
        return -1;
    }

    private static int indexOfType(XBreakpointType type) {
        return (int)XBreakpointUtil.breakpointTypes().indexOf((Object)type).orElse(-1L);
    }
}

