/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluationDialog
extends DialogWrapper {
    public static final DataKey<XDebuggerEvaluationDialog> KEY = DataKey.create((String)"DEBUGGER_EVALUATION_DIALOG");
    private static final int ADD_WATCH_MODIFIERS = (SystemInfo.isMac ? 4 : 2) | 1;
    static KeyStroke ADD_WATCH_KEYSTROKE = KeyStroke.getKeyStroke(10, ADD_WATCH_MODIFIERS);
    private final JPanel myMainPanel;
    private final JPanel myResultPanel;
    private final XDebuggerTreePanel myTreePanel;
    private EvaluationInputComponent myInputComponent;
    private final XDebugSession mySession;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private EvaluationMode myMode;
    private XSourcePosition mySourcePosition;
    private final SwitchModeAction mySwitchModeAction;
    private final boolean myIsCodeFragmentEvaluationSupported;

    public XDebuggerEvaluationDialog(@NotNull XDebugSession session2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XDebuggerEvaluator evaluator2, @NotNull XExpression text2, @Nullable XSourcePosition sourcePosition) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (evaluator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        super((Component)WindowManager.getInstance().getFrame(session2.getProject()), true);
        this.mySession = session2;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.setModal(false);
        this.setOKButtonText(XDebuggerBundle.message((String)"xdebugger.button.evaluate", (Object[])new Object[0]));
        this.setCancelButtonText(XDebuggerBundle.message((String)"xdebugger.evaluate.dialog.close", (Object[])new Object[0]));
        this.mySession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> XDebuggerEvaluationDialog.this.close(1));
            }

            public void stackFrameChanged() {
                XDebuggerEvaluationDialog.this.updateSourcePosition();
            }

            public void sessionPaused() {
                XDebuggerEvaluationDialog.this.updateSourcePosition();
            }
        }, this.myDisposable);
        this.myTreePanel = new XDebuggerTreePanel(session2.getProject(), editorsProvider, this.myDisposable, sourcePosition, "XDebugger.Evaluation.Dialog.Tree.Popup", ((XDebugSessionImpl)session2).getValueMarkers());
        this.myResultPanel = JBUI.Panels.simplePanel().addToTop((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.result", (Object[])new Object[0]))).addToCenter((Component)this.myTreePanel.getMainPanel());
        this.myMainPanel = new EvaluationMainPanel();
        this.mySwitchModeAction = new SwitchModeAction();
        new AnAction(){

            public void update(AnActionEvent e2) {
                Project project2 = e2.getProject();
                e2.getPresentation().setEnabled(project2 != null && LookupManager.getInstance(project2).getActiveLookup() == null);
            }

            public void actionPerformed(AnActionEvent e2) {
                XDebuggerEvaluationDialog.this.addToWatches();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ADD_WATCH_KEYSTROKE), (JComponent)this.getRootPane(), this.myDisposable);
        new AnAction(){

            public void actionPerformed(AnActionEvent e2) {
                IdeFocusManager.getInstance((Project)XDebuggerEvaluationDialog.this.mySession.getProject()).requestFocus((Component)((Object)XDebuggerEvaluationDialog.this.myTreePanel.getTree()), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 512)), (JComponent)this.getRootPane(), this.myDisposable);
        Condition rootFilter = node -> node.getParent() instanceof EvaluatingExpressionRootNode;
        this.myTreePanel.getTree().expandNodesOnLoad((Condition<TreeNode>)rootFilter);
        this.myTreePanel.getTree().selectNodeOnLoad((Condition<TreeNode>)rootFilter);
        EvaluationMode mode = XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().getEvaluationDialogMode();
        this.myIsCodeFragmentEvaluationSupported = evaluator2.isCodeFragmentEvaluationSupported();
        if (mode == EvaluationMode.CODE_FRAGMENT && !this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.EXPRESSION;
        }
        if (mode == EvaluationMode.EXPRESSION && text2.getMode() == EvaluationMode.CODE_FRAGMENT && this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.CODE_FRAGMENT;
        }
        this.switchToMode(mode, text2);
        this.init();
    }

    protected void dispose() {
        super.dispose();
        this.myMainPanel.removeAll();
    }

    private void updateSourcePosition() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.mySourcePosition = this.mySession.getCurrentPosition();
            this.getInputEditor().setSourcePosition(this.mySourcePosition);
        });
    }

    protected void doOKAction() {
        this.evaluate();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e2) {
                super.actionPerformed(e2);
                if ((e2.getModifiers() & ADD_WATCH_MODIFIERS) == ADD_WATCH_MODIFIERS) {
                    XDebuggerEvaluationDialog.this.addToWatches();
                }
            }
        };
    }

    private void addToWatches() {
        XDebugSessionTab tab;
        XExpression expression;
        if (this.myMode == EvaluationMode.EXPRESSION && !XDebuggerUtilImpl.isEmptyExpression(expression = this.getInputEditor().getExpression()) && (tab = ((XDebugSessionImpl)this.mySession).getSessionTab()) != null) {
            tab.getWatchesView().addWatchExpression(expression, -1, true);
            this.getInputEditor().requestFocusInEditor();
        }
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myIsCodeFragmentEvaluationSupported) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.mySwitchModeAction, this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "debugging.debugMenu.evaluate";
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button = super.createJButtonForAction(action2);
        if (action2 == this.mySwitchModeAction) {
            int width1 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.EXPRESSION)).getPreferredSize().width;
            int width2 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.CODE_FRAGMENT)).getPreferredSize().width;
            Dimension size = new Dimension(Math.max(width1, width2), button.getPreferredSize().height);
            button.setMinimumSize(size);
            button.setPreferredSize(size);
        }
        return button;
    }

    public XExpression getExpression() {
        return this.getInputEditor().getExpression();
    }

    private static String getSwitchButtonText(EvaluationMode mode) {
        return mode != EvaluationMode.EXPRESSION ? XDebuggerBundle.message((String)"button.text.expression.mode", (Object[])new Object[0]) : XDebuggerBundle.message((String)"button.text.code.fragment.mode", (Object[])new Object[0]);
    }

    private void switchToMode(EvaluationMode mode, XExpression text2) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        if (mode == EvaluationMode.EXPRESSION) {
            text2 = new XExpressionImpl(StringUtil.convertLineSeparators((String)text2.getExpression(), (String)" "), text2.getLanguage(), text2.getCustomInfo());
        }
        this.myInputComponent = this.createInputComponent(mode, text2);
        this.myMainPanel.removeAll();
        this.myInputComponent.addComponent(this.myMainPanel, this.myResultPanel);
        this.setTitle(this.myInputComponent.getTitle());
        this.mySwitchModeAction.putValue("Name", XDebuggerEvaluationDialog.getSwitchButtonText(mode));
        this.getInputEditor().requestFocusInEditor();
    }

    private XDebuggerEditorBase getInputEditor() {
        return this.myInputComponent.getInputEditor();
    }

    private EvaluationInputComponent createInputComponent(EvaluationMode mode, XExpression text2) {
        Project project2 = this.mySession.getProject();
        text2 = XExpressionImpl.changeMode(text2, mode);
        if (mode == EvaluationMode.EXPRESSION) {
            return new ExpressionInputComponent(project2, this.myEditorsProvider, this.mySourcePosition, text2, this.myDisposable);
        }
        return new CodeFragmentInputComponent(project2, this.myEditorsProvider, this.mySourcePosition, text2, this.getDimensionServiceKey() + ".splitter", this.myDisposable);
    }

    private void evaluate() {
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        int offset = -1;
        Editor editor = inputEditor.getEditor();
        if (editor != null) {
            offset = editor.getCaretModel().getOffset();
        }
        XDebuggerTree tree2 = this.myTreePanel.getTree();
        tree2.markNodesObsolete();
        tree2.setRoot(new EvaluatingExpressionRootNode(this, tree2), false);
        this.myResultPanel.invalidate();
        editor = inputEditor.getEditor();
        inputEditor.selectAll();
        if (offset >= 0 && editor != null) {
            offset = Math.min(editor.getDocument().getTextLength(), offset);
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    public void doCancelAction() {
        this.getInputEditor().saveTextInHistory();
        super.doCancelAction();
    }

    protected String getDimensionServiceKey() {
        return "#xdebugger.evaluate";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void startEvaluation(@NotNull XDebuggerEvaluator.XEvaluationCallback evaluationCallback) {
        if (evaluationCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationCallback", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "startEvaluation"));
        }
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        inputEditor.saveTextInHistory();
        XExpression expression = inputEditor.getExpression();
        XDebuggerEvaluator evaluator2 = this.mySession.getDebugProcess().getEvaluator();
        if (evaluator2 == null) {
            evaluationCallback.errorOccurred(XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        } else {
            evaluator2.evaluate(expression, evaluationCallback, null);
        }
    }

    public void evaluationDone() {
        this.mySession.rebuildViews();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInputEditor().getPreferredFocusedComponent();
    }

    private class EvaluationMainPanel
    extends BorderLayoutPanel
    implements DataProvider {
        private EvaluationMainPanel() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return XDebuggerEvaluationDialog.this;
            }
            return null;
        }
    }

    private class SwitchModeAction
    extends AbstractAction {
        private SwitchModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            XExpression text2 = XDebuggerEvaluationDialog.this.getInputEditor().getExpression();
            EvaluationMode newMode = XDebuggerEvaluationDialog.this.myMode == EvaluationMode.EXPRESSION ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
            XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().setEvaluationDialogMode(newMode);
            XDebuggerEvaluationDialog.this.switchToMode(newMode, text2);
        }
    }
}

