/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(XValueHint.class);
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession myDebugSession;
    private final String myExpression;
    private final String myValueName;
    @Nullable
    private final XSourcePosition myExpressionPosition;
    private final ExpressionInfo myExpressionInfo;
    private Disposable myDisposable;
    private static final Key<XValueHint> HINT_KEY = Key.create((String)"allows only one value hint per editor");

    public XValueHint(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator2, @NotNull XDebugSession session2) {
        LanguageConsoleView console;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (evaluator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        super(project2, editor, point, type, expressionInfo.getTextRange());
        this.myEvaluator = evaluator2;
        this.myDebugSession = session2;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText(expressionInfo, editor.getDocument());
        this.myExpressionInfo = expressionInfo;
        ConsoleView consoleView = (ConsoleView)ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW.get((UserDataHolder)editor);
        VirtualFile file2 = consoleView instanceof LanguageConsoleView ? ((console = (LanguageConsoleView)consoleView).getHistoryViewer() == editor ? console.getVirtualFile() : null) : FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file2 != null ? XDebuggerUtil.getInstance().createPositionByOffset(file2, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    @Override
    protected boolean canShowHint() {
        return true;
    }

    @Override
    protected boolean showHint(JComponent component) {
        boolean result2 = super.showHint(component);
        if (result2 && this.getType() == ValueHintType.MOUSE_OVER_HINT) {
            this.myDisposable = Disposer.newDisposable();
            ShortcutSet shortcut = ActionManager.getInstance().getAction("ShowErrorDescription").getShortcutSet();
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "actionPerformed"));
                    }
                    XValueHint.this.hideHint();
                    Point point = new Point(((XValueHint)XValueHint.this).myPoint.x, ((XValueHint)XValueHint.this).myPoint.y + XValueHint.this.getEditor().getLineHeight());
                    new XValueHint(XValueHint.this.getProject(), XValueHint.this.getEditor(), point, ValueHintType.MOUSE_CLICK_HINT, XValueHint.this.myExpressionInfo, XValueHint.this.myEvaluator, XValueHint.this.myDebugSession).invokeHint();
                }
            }.registerCustomShortcutSet(shortcut, this.getEditor().getContentComponent(), this.myDisposable);
        }
        if (result2) {
            XValueHint prev = (XValueHint)this.getEditor().getUserData(HINT_KEY);
            if (prev != null) {
                prev.hideHint();
            }
            this.getEditor().putUserData(HINT_KEY, (Object)this);
        }
        return result2;
    }

    @Override
    protected void onHintHidden() {
        super.onHintHidden();
        XValueHint prev = (XValueHint)this.getEditor().getUserData(HINT_KEY);
        if (prev == this) {
            this.getEditor().putUserData(HINT_KEY, null);
        }
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    @Override
    public void hideHint() {
        super.hideHint();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    @Override
    protected void evaluateAndShowHint() {
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2", "evaluated"));
                }
                result2.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;
                    private boolean myShown = false;

                    @Override
                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2$1", "applyPresentation"));
                        }
                        if (XValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text2 = new SimpleColoredText();
                        text2.append(StringUtil.trimMiddle((String)XValueHint.this.myValueName, (int)200), XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        XValueNodeImpl.buildText(valuePresenter, (ColoredTextContainer)text2);
                        if (!hasChildren) {
                            SimpleColoredComponent component = HintUtil.createInformationComponent();
                            text2.appendToComponent((ColoredTextContainer)component);
                            if (this.myFullValueEvaluator != null) {
                                component.append(this.myFullValueEvaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, event -> DebuggerUIUtil.showValuePopup(this.myFullValueEvaluator, event, XValueHint.this.getProject(), XValueHint.this.getEditor()));
                                LinkMouseListenerBase.installSingleTagOn(component);
                            }
                            XValueHint.this.showHint((JComponent)component);
                        } else if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            if (!this.myShown) {
                                XValueHint.this.showTree(result2);
                            }
                        } else {
                            if (XValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                text2.insert(0, "(" + KeymapUtil.getFirstKeyboardShortcutText((String)"ShowErrorDescription") + ") ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            }
                            JComponent component = XValueHint.this.createExpandableHintComponent(text2, () -> {
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2$1", "lambda$applyPresentation$1"));
                                }
                                XValueHint.this.showTree(result2);
                            });
                            XValueHint.this.showHint(component);
                        }
                        this.myShown = true;
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2$1", "setFullValueEvaluator"));
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return XValueHint.this.isHintHidden();
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2", "errorOccurred"));
                }
                if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$2", "lambda$errorOccurred$0"));
                        }
                        XValueHint.this.showHint(HintUtil.createErrorLabel(errorMessage));
                    });
                }
                LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
            }
        }, this.myExpressionPosition);
    }

    private void showTree(@NotNull XValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "showTree"));
        }
        XValueMarkers<?, ?> valueMarkers = ((XDebugSessionImpl)this.myDebugSession).getValueMarkers();
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.myDebugSession.getProject(), this.myDebugSession.getDebugProcess().getEditorsProvider(), this.myDebugSession.getCurrentPosition(), valueMarkers);
        this.showTreePopup(creator, Pair.create((Object)value2, (Object)this.myValueName));
    }
}

