/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.awt.Component;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebugView
implements Disposable {
    private final SingleAlarm myClearAlarm = new SingleAlarm(() -> this.clear(), 100, this);
    private static final int VIEW_CLEAR_DELAY = 100;

    protected final void requestClear() {
        this.myClearAlarm.cancelAndRequest();
    }

    protected final void cancelClear() {
        this.myClearAlarm.cancel();
    }

    protected abstract void clear();

    public abstract void processSessionEvent(@NotNull SessionEvent var1, @NotNull XDebugSession var2);

    @Nullable
    protected static XDebugSession getSession(@NotNull EventObject e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XDebugView", "getSession"));
        }
        Component component = e2.getSource() instanceof Component ? (Component)e2.getSource() : null;
        return component == null ? null : XDebugView.getSession(component);
    }

    @Nullable
    public static XDebugSession getSession(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/xdebugger/impl/frame/XDebugView", "getSession"));
        }
        return (XDebugSession)XDebugView.getData(XDebugSession.DATA_KEY, component);
    }

    @Nullable
    protected VirtualFile getCurrentFile(@NotNull Component component) {
        XSourcePosition position;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/xdebugger/impl/frame/XDebugView", "getCurrentFile"));
        }
        XDebugSession session2 = XDebugView.getSession(component);
        if (session2 != null && (position = session2.getCurrentPosition()) != null) {
            return position.getFile();
        }
        return null;
    }

    @Nullable
    public static <T> T getData(DataKey<T> key, @NotNull Component component) {
        Object data;
        ContentManager contentManager;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/xdebugger/impl/frame/XDebugView", "getData"));
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(component);
        ViewContext viewContext = (ViewContext)ViewContext.CONTEXT_KEY.getData(dataContext);
        ContentManager contentManager2 = contentManager = viewContext == null ? null : viewContext.getContentManager();
        if (contentManager != null && (data = key.getData(DataManager.getInstance().getDataContext((Component)contentManager.getComponent()))) != null) {
            return (T)data;
        }
        return (T)key.getData(dataContext);
    }

    public static enum SessionEvent {
        PAUSED,
        BEFORE_RESUME,
        RESUMED,
        STOPPED,
        FRAME_CHANGED,
        SETTINGS_CHANGED;

    }
}

