/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList {
    private final Project myProject;
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c2) {
            if (!(c2 instanceof XDebuggerFramesList)) {
                return null;
            }
            XDebuggerFramesList list2 = (XDebuggerFramesList)((Object)c2);
            Object[] values = list2.getSelectedValues();
            if (values == null || values.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            for (Object value2 : values) {
                htmlBuf.append("  <li>");
                if (value2 != null) {
                    if (value2 instanceof XStackFrame) {
                        ((XStackFrame)value2).customizePresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text2 = value2.toString();
                        plainBuf.append(text2);
                        htmlBuf.append(text2);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf.toString(), plainBuf.toString());
        }

        @Override
        public int getSourceActions(@NotNull JComponent c2) {
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$1", "getSourceActions"));
            }
            return 1;
        }
    };
    private XStackFrame mySelectedFrame;

    public XDebuggerFramesList(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList", "<init>"));
        }
        this.myProject = project2;
        this.doInit();
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (XDebuggerFramesList.this.mySelectedFrame != null) {
                    VirtualFile file2;
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame);
                    }
                    if (CommonDataKeys.PSI_FILE.is(dataId) && (file2 = XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame)) != null && file2.isValid()) {
                        return PsiManager.getInstance((Project)XDebuggerFramesList.this.myProject).findFile(file2);
                    }
                }
                return null;
            }
        });
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerGroupedFrameListRenderer();
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        if (this.mySelectedFrame != selectedValue) {
            SwingUtilities.invokeLater(() -> this.repaint());
            this.mySelectedFrame = selectedValue instanceof XStackFrame ? (XStackFrame)selectedValue : null;
        }
    }

    public static interface ItemWithSeparatorAbove {
        public boolean hasSeparatorAbove();
    }

    private static class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private final FileColorManager myColorsManager;

        public XDebuggerFrameListRenderer(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer", "<init>"));
            }
            this.myColorsManager = FileColorManager.getInstance((Project)project2);
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer", "customizeCellRenderer"));
            }
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if (value2 == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value2 instanceof String) {
                this.append((String)value2, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value2;
            if (!selected) {
                Color c2 = null;
                XSourcePosition position = stackFrame.getSourcePosition();
                if (position != null) {
                    VirtualFile virtualFile = position.getFile();
                    if (virtualFile.isValid()) {
                        c2 = this.myColorsManager.getFileColor(virtualFile);
                    }
                } else {
                    c2 = this.myColorsManager.getScopeColor("Non-Project Files");
                }
                if (c2 != null) {
                    this.setBackground(c2);
                }
            }
            stackFrame.customizePresentation((ColoredTextContainer)this);
        }
    }

    private class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer {
        public XDebuggerGroupedFrameListRenderer() {
            super(new ListItemDescriptorAdapter(){

                @Nullable
                public String getTextFor(Object value2) {
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value2) {
                    if (value2 instanceof ItemWithSeparatorAbove) {
                        return ((ItemWithSeparatorAbove)value2).hasSeparatorAbove();
                    }
                    return false;
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            ((XDebuggerFrameListRenderer)((Object)this.myComponent)).getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            return component;
        }

        @Override
        protected JComponent createItemComponent() {
            this.createLabel();
            return new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
        }
    }
}

