/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XVariablesView
extends XVariablesViewBase
implements DataProvider {
    public static final Key<InlineVariablesInfo> DEBUG_VARIABLES = Key.create((String)"debug.variables");
    private final JPanel myComponent;

    public XVariablesView(@NotNull XDebugSessionImpl session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XVariablesView", "<init>"));
        }
        super(session2.getProject(), session2.getDebugProcess().getEditorsProvider(), session2.getValueMarkers());
        this.myComponent = new BorderLayoutPanel();
        this.myComponent.add(super.getPanel());
        DataManager.registerDataProvider((JComponent)this.myComponent, (DataProvider)this);
    }

    @Override
    public JPanel getPanel() {
        return this.myComponent;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XVariablesView", "processSessionEvent"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XVariablesView", "processSessionEvent"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.getTree().markNodesObsolete();
        }
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        DebuggerUIUtil.invokeLater(() -> {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XVariablesView", "lambda$processSessionEvent$0"));
            }
            XDebuggerTree tree2 = this.getTree();
            if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
                this.saveCurrentTreeState(stackFrame);
                if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                    return;
                }
            }
            tree2.markNodesObsolete();
            if (stackFrame != null) {
                this.cancelClear();
                this.buildTreeAndRestoreState(stackFrame);
            } else {
                this.requestClear();
            }
        });
    }

    @Override
    public void dispose() {
        XVariablesView.clearInlineData(this.getTree());
        super.dispose();
    }

    private static void clearInlineData(XDebuggerTree tree2) {
        tree2.getProject().putUserData(DEBUG_VARIABLES, null);
        tree2.updateEditor();
        XVariablesView.clearInlays(tree2);
    }

    protected void addEmptyMessage(XValueContainerNode root) {
        XDebugSession session2 = XVariablesView.getSession(this.getPanel());
        if (session2 != null) {
            if (!session2.isStopped() && session2.isPaused()) {
                root.setInfoMessage("Frame is not available", null);
            } else {
                XDebugProcess debugProcess = session2.getDebugProcess();
                root.setInfoMessage(debugProcess.getCurrentStateMessage(), debugProcess.getCurrentStateHyperlinkListener());
            }
        }
    }

    @Override
    protected void clear() {
        XDebuggerTree tree2 = this.getTree();
        tree2.setSourcePosition(null);
        XVariablesView.clearInlineData(tree2);
        XValueContainerNode root = this.createNewRootNode(null);
        this.addEmptyMessage(root);
        super.clear();
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.getCurrentFile((Component)((Object)this.getTree()));
        }
        return null;
    }

    public static class InlineVariablesInfo {
        private final Map<Pair<VirtualFile, Integer>, Set<Entry>> myData = new THashMap();
        private final TObjectLongHashMap<VirtualFile> myTimestamps = new ObjectLongHashMap();

        @Nullable
        public synchronized List<XValueNodeImpl> get(@NotNull VirtualFile file2, int line, long currentTimestamp) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "get"));
            }
            long timestamp = this.myTimestamps.get((Object)file2);
            if (timestamp == -1L || timestamp < currentTimestamp) {
                return null;
            }
            Set<Entry> entries = this.myData.get(Pair.create((Object)file2, (Object)line));
            if (entries == null) {
                return null;
            }
            return ContainerUtil.map(entries, entry -> ((Entry)entry).myNode);
        }

        public synchronized void put(@NotNull VirtualFile file2, @NotNull XSourcePosition position, @NotNull XValueNodeImpl node, long timestamp) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            this.myTimestamps.put((Object)file2, timestamp);
            Pair key = Pair.create((Object)file2, (Object)position.getLine());
            this.myData.computeIfAbsent((Pair<VirtualFile, Integer>)key, k2 -> new TreeSet()).add(new Entry(position.getOffset(), node));
        }

        private static class Entry
        implements Comparable<Entry> {
            private final long myOffset;
            private final XValueNodeImpl myNode;

            /*
             * WARNING - void declaration
             */
            public Entry(long offset, @NotNull XValueNodeImpl xValueNodeImpl) {
                void node;
                if (xValueNodeImpl == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo$Entry", "<init>"));
                }
                this.myOffset = offset;
                this.myNode = node;
            }

            @Override
            public int compareTo(Entry o2) {
                if (this.myNode == o2.myNode) {
                    return 0;
                }
                int res2 = Comparing.compare((long)this.myOffset, (long)o2.myOffset);
                if (res2 == 0) {
                    return XValueNodeImpl.COMPARATOR.compare(this.myNode, o2.myNode);
                }
                return res2;
            }

            public boolean equals(Object o2) {
                if (this == o2) {
                    return true;
                }
                if (o2 == null || this.getClass() != o2.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o2;
                return this.myNode.equals(entry.myNode);
            }

            public int hashCode() {
                return this.myNode.hashCode();
            }
        }
    }
}

