/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XStackFrameNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XVariablesViewBase
extends XDebugView {
    private final XDebuggerTreePanel myTreePanel;
    private XDebuggerTreeState myTreeState;
    private XDebuggerTreeRestorer myTreeRestorer;
    private Object myFrameEqualityObject;
    private MySelectionListener mySelectionListener;

    protected XVariablesViewBase(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XValueMarkers<?, ?> markers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "<init>"));
        }
        this.myTreePanel = new XDebuggerTreePanel(project2, editorsProvider, this, null, this instanceof XWatchesView ? "XDebugger.Watches.Tree.Popup" : "XDebugger.Variables.Tree.Popup", markers);
        this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.variables.not.available", (Object[])new Object[0]));
        DnDManager.getInstance().registerSource((DnDSource)this.myTreePanel, (JComponent)((Object)this.getTree()));
    }

    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrame", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "buildTreeAndRestoreState"));
        }
        XSourcePosition position = stackFrame.getSourcePosition();
        XDebuggerTree tree2 = this.getTree();
        tree2.setSourcePosition(position);
        this.createNewRootNode(stackFrame);
        Project project2 = tree2.getProject();
        project2.putUserData(XVariablesView.DEBUG_VARIABLES, (Object)new XVariablesView.InlineVariablesInfo());
        XVariablesViewBase.clearInlays(tree2);
        Object newEqualityObject = stackFrame.getEqualityObject();
        if (this.myFrameEqualityObject != null && newEqualityObject != null && this.myFrameEqualityObject.equals(newEqualityObject) && this.myTreeState != null) {
            this.disposeTreeRestorer();
            this.myTreeRestorer = this.myTreeState.restoreState(tree2);
        }
        if (position != null && Registry.is((String)"debugger.valueTooltipAutoShowOnSelection")) {
            this.registerInlineEvaluator(stackFrame, position, project2);
        }
    }

    protected static void clearInlays(XDebuggerTree tree2) {
        if (Registry.is((String)"debugger.show.values.inplace")) {
            XDebuggerInlayUtil.clearInlays(tree2.getProject());
        }
    }

    protected XValueContainerNode createNewRootNode(@Nullable XStackFrame stackFrame) {
        XValueContainerNode root = stackFrame == null ? new XValueContainerNode<XValueContainer>(this.getTree(), null, new XValueContainer(){}){} : new XStackFrameNode(this.getTree(), stackFrame);
        this.getTree().setRoot(root, false);
        return root;
    }

    private void registerInlineEvaluator(XStackFrame stackFrame, XSourcePosition position, Project project2) {
        VirtualFile file2 = position.getFile();
        FileEditor fileEditor = FileEditorManagerEx.getInstanceEx(project2).getSelectedEditor(file2);
        if (fileEditor instanceof PsiAwareTextEditorImpl) {
            Editor editor = ((PsiAwareTextEditorImpl)fileEditor).getEditor();
            this.removeSelectionListener();
            this.mySelectionListener = new MySelectionListener(editor, stackFrame, project2);
            editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionListener);
        }
    }

    protected void saveCurrentTreeState(@Nullable XStackFrame stackFrame) {
        this.removeSelectionListener();
        Object object = this.myFrameEqualityObject = stackFrame != null ? stackFrame.getEqualityObject() : null;
        if (this.myTreeRestorer == null || this.myTreeRestorer.isFinished()) {
            this.myTreeState = XDebuggerTreeState.saveState(this.getTree());
        }
        this.disposeTreeRestorer();
    }

    private void removeSelectionListener() {
        if (this.mySelectionListener != null) {
            this.mySelectionListener.remove();
            this.mySelectionListener = null;
        }
    }

    @Override
    protected void clear() {
        this.removeSelectionListener();
    }

    private void disposeTreeRestorer() {
        if (this.myTreeRestorer != null) {
            this.myTreeRestorer.dispose();
            this.myTreeRestorer = null;
        }
    }

    @NotNull
    public final XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.myTreePanel.getTree();
        if (xDebuggerTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "getTree"));
        }
        return xDebuggerTree;
    }

    public JComponent getPanel() {
        return this.myTreePanel.getMainPanel();
    }

    public void dispose() {
        this.disposeTreeRestorer();
        this.removeSelectionListener();
        DnDManager.getInstance().unregisterSource((DnDSource)this.myTreePanel, (JComponent)((Object)this.getTree()));
    }

    private class MySelectionListener
    implements SelectionListener {
        private final Editor myEditor;
        private final XStackFrame myStackFrame;
        private final Project myProject;

        public MySelectionListener(Editor editor, XStackFrame stackFrame, Project project2) {
            this.myEditor = editor;
            this.myStackFrame = stackFrame;
            this.myProject = project2;
        }

        public void remove() {
            this.myEditor.getSelectionModel().removeSelectionListener((SelectionListener)this);
        }

        public void selectionChanged(SelectionEvent e2) {
            if (!Registry.is((String)"debugger.valueTooltipAutoShowOnSelection") || this.myEditor.getCaretModel().getCaretCount() > 1) {
                return;
            }
            String text2 = this.myEditor.getDocument().getText(e2.getNewRange());
            if (!(StringUtil.isEmpty((String)text2) || text2.contains("exec(") || text2.contains("++") || text2.contains("--") || text2.contains("="))) {
                XDebugSession session2 = XDebugView.getSession((Component)((Object)XVariablesViewBase.this.getTree()));
                if (session2 == null) {
                    return;
                }
                XDebuggerEvaluator evaluator2 = this.myStackFrame.getEvaluator();
                if (evaluator2 == null) {
                    return;
                }
                TextRange range = e2.getNewRange();
                ExpressionInfo info = new ExpressionInfo(range);
                int offset = range.getStartOffset();
                LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset);
                Point point = this.myEditor.logicalPositionToXY(pos);
                new XValueHint(this.myProject, this.myEditor, point, ValueHintType.MOUSE_OVER_HINT, info, evaluator2, session2).invokeHint();
            }
        }
    }
}

