/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XWatchesViewImpl
extends XVariablesView
implements DnDNativeTarget,
XWatchesView {
    private WatchesRootNode myRootNode;
    private final CompositeDisposable myDisposables;
    private final boolean myWatchesInVariables;

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "<init>"));
        }
        super(session2);
        this.myDisposables = new CompositeDisposable();
        this.myWatchesInVariables = watchesInVariables;
        XDebuggerTree tree2 = this.getTree();
        this.createNewRootNode(null);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.NewWatch", (JComponent)((Object)tree2), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.RemoveWatch", (JComponent)((Object)tree2), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyWatch", (JComponent)((Object)tree2), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.EditWatch", (JComponent)((Object)tree2), (Disposable)this.myDisposables);
        EmptyAction.registerWithShortcutSet((String)"XDebugger.NewWatch", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)((Object)tree2));
        EmptyAction.registerWithShortcutSet((String)"XDebugger.RemoveWatch", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)tree2));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree2));
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
                }
                Object contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR);
                if (contents instanceof List) {
                    for (Object item : (List)contents) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), (JComponent)((Object)tree2), (Disposable)this.myDisposables);
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Tree.Toolbar"), !this.myWatchesInVariables);
        toolbar.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, this.myWatchesInVariables ? 0 : 1, this.myWatchesInVariables ? 1 : 0));
        toolbar.setTargetComponent((JComponent)((Object)tree2));
        if (!this.myWatchesInVariables) {
            this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
        }
        this.getPanel().add((Component)toolbar.getComponent(), this.myWatchesInVariables ? "West" : "North");
        this.installEditListeners();
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.getTree();
        final Alarm quitePeriod = new Alarm();
        final Alarm editAlarm = new Alarm();
        final ClickListener mouseListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2", "onClick"));
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree, false);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancelAllRequests();
                    return false;
                }
                AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation = editWatchAction.getTemplatePresentation().clone();
                DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                AnActionEvent actionEvent = new AnActionEvent(null, context2, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                Runnable runnable2 = () -> editWatchAction.actionPerformed(actionEvent);
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.addRequest(runnable2, UIUtil.getMultiClickInterval());
                } else {
                    editAlarm.cancelAllRequests();
                }
                return false;
            }
        };
        DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree, true)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), mouseListener);
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseEmptySpaceListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$4", "focusGained"));
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$4", "focusLost"));
                }
                editAlarm.cancelAllRequests();
            }
        };
        ListenerUtil.addFocusListener((Component)((Object)watchTree), focusListener);
        TreeSelectionListener selectionListener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$5", "valueChanged"));
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }
        };
        watchTree.addTreeSelectionListener(selectionListener2);
        this.myDisposables.add(new Disposable((ClickListener)mouseEmptySpaceListener, focusListener, selectionListener2){
            final /* synthetic */ ClickListener val$mouseEmptySpaceListener;
            final /* synthetic */ FocusListener val$focusListener;
            final /* synthetic */ TreeSelectionListener val$selectionListener;
            {
                this.val$mouseEmptySpaceListener = clickListener2;
                this.val$focusListener = focusListener;
                this.val$selectionListener = treeSelectionListener;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), mouseListener);
                ListenerUtil.removeClickListener((Component)((Object)watchTree), this.val$mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener((Component)((Object)watchTree), this.val$focusListener);
                watchTree.removeTreeSelectionListener(this.val$selectionListener);
            }
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.getTree()));
        super.dispose();
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree, boolean fullWidth) {
        Rectangle bounds = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds != null) {
            if (fullWidth) {
                bounds.x = 0;
            }
            bounds.width = watchTree.getWidth();
            if (bounds.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    private void executeAction(@NotNull String watch) {
        if (watch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watch", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "executeAction"));
        }
        AnAction action2 = ActionManager.getInstance().getAction(watch);
        Presentation presentation = action2.getTemplatePresentation().clone();
        DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)this.getTree()));
        AnActionEvent actionEvent = new AnActionEvent(null, context2, "DebuggerToolbar", presentation, ActionManager.getInstance(), 0);
        action2.actionPerformed(actionEvent);
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "addWatchExpression"));
        }
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        this.myRootNode.addWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, expression, index, navigateToWatchNode);
        this.updateSessionData();
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    public void computeWatches() {
        this.myRootNode.computeWatches();
    }

    @Override
    protected XValueContainerNode createNewRootNode(@Nullable XStackFrame stackFrame) {
        WatchesRootNode node;
        this.myRootNode = node = new WatchesRootNode(this.getTree(), this, this.getExpressions(), stackFrame, this.myWatchesInVariables);
        this.getTree().setRoot(node, false);
        return node;
    }

    @Override
    protected void addEmptyMessage(XValueContainerNode root) {
        if (this.myWatchesInVariables) {
            super.addEmptyMessage(root);
        }
    }

    @NotNull
    private XExpression[] getExpressions() {
        XExpression[] expressions;
        XDebuggerTree tree2 = this.getTree();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)tree2));
        if (session2 != null) {
            expressions = ((XDebugSessionImpl)session2).getSessionData().getWatchExpressions();
        } else {
            XDebuggerTreeNode root = tree2.getRoot();
            List<WatchNode> current = root instanceof WatchesRootNode ? ((WatchesRootNode)tree2.getRoot()).getWatchChildren() : Collections.emptyList();
            ArrayList list2 = ContainerUtil.newArrayList();
            for (WatchNode child : current) {
                list2.add(child.getExpression());
            }
            expressions = list2.toArray(new XExpression[list2.size()]);
        }
        if (expressions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "getExpressions"));
        }
        return expressions;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove = new ArrayList<XDebuggerTreeNode>();
        for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
            int index = children2.indexOf(xDebuggerTreeNode);
            if (index == -1) continue;
            toRemove.add(xDebuggerTreeNode);
            minIndex = Math.min(minIndex, index);
        }
        this.myRootNode.removeChildren(toRemove);
        List<? extends WatchNode> newChildren = this.myRootNode.getWatchChildren();
        if (!newChildren.isEmpty()) {
            WatchNode watchNode = newChildren.get(Math.min(minIndex, newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)watchNode);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void moveWatchUp(WatchNode node) {
        this.myRootNode.moveUp(node);
        this.updateSessionData();
    }

    public void moveWatchDown(WatchNode node) {
        this.myRootNode.moveDown(node);
        this.updateSessionData();
    }

    public void updateSessionData() {
        ArrayList watchExpressions = ContainerUtil.newArrayList();
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        for (WatchNode watchNode : children2) {
            watchExpressions.add(watchNode.getExpression());
        }
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        XExpression[] xExpressionArray = watchExpressions.toArray(new XExpression[watchExpressions.size()]);
        if (session2 != null) {
            ((XDebugSessionImpl)session2).setWatchExpressions(xExpressionArray);
        } else {
            XDebugSessionData data = XWatchesViewImpl.getData(XDebugSessionData.DATA_KEY, (Component)((Object)this.getTree()));
            if (data != null) {
                data.setWatchExpressions(xExpressionArray);
            }
        }
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
            if (((XValueNodeImpl[])object).length == 1) {
                Point point = aEvent.getPoint();
                XDebuggerTree tree2 = this.getTree();
                TreePath path = tree2.getClosestPathForLocation(point.x, point.y);
                if (path != null && path.getLastPathComponent() == ((XValueNodeImpl[])object)[0]) {
                    Rectangle pathBounds = tree2.getPathBounds(path);
                    possible = pathBounds != null && pathBounds.y + pathBounds.height < point.y;
                }
            }
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text2;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            XValueNodeImpl[] nodes;
            for (XValueNodeImpl node : nodes = (XValueNodeImpl[])object) {
                ((XValue)node.getValueContainer()).calculateEvaluationExpression().done(expression -> {
                    if (expression != null) {
                        this.addWatchExpression((XExpression)expression, -1, false);
                    }
                });
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text2 = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text2), -1, false);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }
}

