/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class XWatchesTreeActionBase
extends AnAction
implements DumbAware {
    @NotNull
    public static <T extends TreeNode> List<? extends T> getSelectedNodes(@NotNull XDebuggerTree tree2, Class<T> nodeClass) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/frame/actions/XWatchesTreeActionBase", "getSelectedNodes"));
        }
        ArrayList<T> list2 = new ArrayList<T>();
        TreePath[] selectionPaths = tree2.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                Object element = selectionPath.getLastPathComponent();
                if (!nodeClass.isInstance(element)) continue;
                list2.add(nodeClass.cast(element));
            }
        }
        ArrayList<T> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/actions/XWatchesTreeActionBase", "getSelectedNodes"));
        }
        return arrayList;
    }

    public void update(AnActionEvent e2) {
        XDebuggerTree tree2 = XDebuggerTree.getTree(e2);
        XWatchesView watchesView = (XWatchesView)e2.getData(XWatchesView.DATA_KEY);
        boolean enabled = tree2 != null && watchesView != null && this.isEnabled(e2, tree2);
        e2.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e2) {
        XDebuggerTree tree2 = XDebuggerTree.getTree(e2);
        XWatchesView watchesView = (XWatchesView)e2.getData(XWatchesView.DATA_KEY);
        if (tree2 != null && watchesView != null) {
            this.perform(e2, tree2, watchesView);
        }
    }

    protected abstract void perform(@NotNull AnActionEvent var1, @NotNull XDebuggerTree var2, @NotNull XWatchesView var3);

    protected boolean isEnabled(@NotNull AnActionEvent e2, @NotNull XDebuggerTree tree2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/actions/XWatchesTreeActionBase", "isEnabled"));
        }
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/frame/actions/XWatchesTreeActionBase", "isEnabled"));
        }
        return true;
    }
}

