/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class GeneralConfigurableUi
implements ConfigurableUi<XDebuggerGeneralSettings> {
    private JPanel rootPanel;
    private JCheckBox hideDebugWindowCheckBox;
    private JCheckBox focusApplicationOnBreakpointCheckBox;
    private JCheckBox myShowDebugWindowOnCheckBox;
    private JCheckBox myScrollExecutionPointToCheckBox;
    private JRadioButton myClickRadioButton;
    private JRadioButton myDragToTheEditorRadioButton;

    GeneralConfigurableUi() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull XDebuggerGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/GeneralConfigurableUi", "reset"));
        }
        this.focusApplicationOnBreakpointCheckBox.setSelected(Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint"));
        this.hideDebugWindowCheckBox.setSelected(settings.isHideDebuggerOnProcessTermination());
        this.myShowDebugWindowOnCheckBox.setSelected(settings.isShowDebuggerOnBreakpoint());
        this.myScrollExecutionPointToCheckBox.setSelected(settings.isScrollToCenter());
        this.myClickRadioButton.setSelected(!Registry.is((String)"debugger.click.disable.breakpoints"));
        this.myDragToTheEditorRadioButton.setSelected(Registry.is((String)"debugger.click.disable.breakpoints"));
    }

    public boolean isModified(@NotNull XDebuggerGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/GeneralConfigurableUi", "isModified"));
        }
        return this.focusApplicationOnBreakpointCheckBox.isSelected() != Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint") || this.hideDebugWindowCheckBox.isSelected() != settings.isHideDebuggerOnProcessTermination() || this.myShowDebugWindowOnCheckBox.isSelected() != settings.isShowDebuggerOnBreakpoint() || this.myScrollExecutionPointToCheckBox.isSelected() != settings.isScrollToCenter() || this.myDragToTheEditorRadioButton.isSelected() != Registry.is((String)"debugger.click.disable.breakpoints");
    }

    public void apply(@NotNull XDebuggerGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/GeneralConfigurableUi", "apply"));
        }
        Registry.get((String)"debugger.mayBringFrameToFrontOnBreakpoint").setValue(this.focusApplicationOnBreakpointCheckBox.isSelected());
        settings.setHideDebuggerOnProcessTermination(this.hideDebugWindowCheckBox.isSelected());
        settings.setShowDebuggerOnBreakpoint(this.myShowDebugWindowOnCheckBox.isSelected());
        settings.setScrollToCenter(this.myScrollExecutionPointToCheckBox.isSelected());
        Registry.get((String)"debugger.click.disable.breakpoints").setValue(this.myDragToTheEditorRadioButton.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.rootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/GeneralConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.hideDebugWindowCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.hide.window.label"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.focusApplicationOnBreakpointCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.focus.app.on.breakpoint.label"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowDebugWindowOnCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.show.window.label"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScrollExecutionPointToCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.scroll.to.center"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.drag.to.remove.breakpoint"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClickRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.drag.to.remove.breakpoint.click"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDragToTheEditorRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.drag.to.remove.breakpoint.drag"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

