/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myNotTopFrame;
    private GutterIconRenderer myGutterIconRenderer;
    private static final Key<Boolean> EXECUTION_POINT_HIGHLIGHTER_KEY = Key.create((String)"EXECUTION_POINT_HIGHLIGHTER_KEY");
    private final AtomicBoolean updateRequested;

    public ExecutionPointHighlighter(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "<init>"));
        }
        this.updateRequested = new AtomicBoolean();
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, scheme2 -> this.update(false));
    }

    public void show(@NotNull XSourcePosition position, boolean notTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "show"));
        }
        this.updateRequested.set(false);
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "lambda$show$1"));
            }
            this.updateRequested.set(false);
            this.mySourcePosition = position;
            this.clearDescriptor();
            this.myOpenFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(this.myProject, position);
            if (!XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isScrollToCenter()) {
                this.myOpenFileDescriptor.setScrollType(notTopFrame ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
            }
            this.myGutterIconRenderer = gutterIconRenderer;
            this.myNotTopFrame = notTopFrame;
            this.doShow(true);
        });
    }

    public void hide() {
        AppUIUtil.invokeOnEdt(() -> {
            this.updateRequested.set(false);
            this.removeHighlighter();
            this.clearDescriptor();
            this.myEditor = null;
            this.myGutterIconRenderer = null;
        });
    }

    private void clearDescriptor() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.dispose();
            this.myOpenFileDescriptor = null;
        }
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null && this.myOpenFileDescriptor.getFile().isValid()) {
            this.myOpenFileDescriptor.navigateInEditor(this.myProject, true);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update(boolean navigate2) {
        if (this.updateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.updateRequested.compareAndSet(true, false)) {
                    this.doShow(navigate2);
                }
            }, this.myProject.getDisposed());
        }
    }

    public void updateGutterIcon(@Nullable GutterIconRenderer renderer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (this.myRangeHighlighter != null && this.myGutterIconRenderer != null) {
                this.myRangeHighlighter.setGutterIconRenderer(renderer);
            }
        });
    }

    private void doShow(boolean navigate2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.removeHighlighter();
        OpenFileDescriptor fileDescriptor = this.myOpenFileDescriptor;
        if (!navigate2 && this.myOpenFileDescriptor != null) {
            fileDescriptor = new OpenFileDescriptor(this.myProject, this.myOpenFileDescriptor.getFile());
        }
        this.myEditor = null;
        if (fileDescriptor != null) {
            FileEditor editor;
            if (!navigate2 && (editor = FileEditorManager.getInstance((Project)fileDescriptor.getProject()).getSelectedEditor(fileDescriptor.getFile())) instanceof TextEditor) {
                this.myEditor = ((TextEditor)editor).getEditor();
            }
            if (this.myEditor == null) {
                this.myEditor = XDebuggerUtilImpl.createEditor(fileDescriptor);
            }
        }
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    private void removeHighlighter() {
        if (this.myEditor != null) {
            ExecutionPointHighlighter.adjustCounter(this.myEditor, -1);
        }
        if (this.myRangeHighlighter != null) {
            this.myRangeHighlighter.dispose();
            this.myRangeHighlighter = null;
        }
    }

    private void addHighlighter() {
        TextRange lineRange;
        TextRange range;
        ExecutionPointHighlighter.adjustCounter(this.myEditor, 1);
        int line = this.mySourcePosition.getLine();
        Document document = this.myEditor.getDocument();
        if (line < 0 || line >= document.getLineCount()) {
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = this.myNotTopFrame ? scheme2.getAttributes(DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES) : scheme2.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES);
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, this.myProject, true);
        if (this.mySourcePosition instanceof HighlighterProvider && (range = ((HighlighterProvider)this.mySourcePosition).getHighlightRange()) != null && (range = range.intersection(lineRange = DocumentUtil.getLineTextRange(document, line))) != null && !range.isEmpty() && !range.equals((Object)lineRange)) {
            this.myRangeHighlighter = markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
        if (this.myRangeHighlighter == null) {
            this.myRangeHighlighter = markupModel.addLineHighlighter(line, 5999, attributes);
        }
        this.myRangeHighlighter.putUserData(EXECUTION_POINT_HIGHLIGHTER_KEY, (Object)true);
        this.myRangeHighlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        this.myRangeHighlighter.setGutterIconRenderer(this.myGutterIconRenderer);
    }

    public boolean isFullLineHighlighter() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRangeHighlighter != null && this.myRangeHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE;
    }

    private static void adjustCounter(@NotNull Editor editor, int increment) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "adjustCounter"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "lambda$adjustCounter$5"));
            }
            JComponent component = editor.getComponent();
            Object o2 = component.getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING);
            Integer value2 = (o2 instanceof Integer ? (Integer)o2 : 0) + increment;
            component.putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, value2 > 0 ? value2 : null);
        });
    }

    public static interface HighlighterProvider {
        @Nullable
        public TextRange getHighlightRange();
    }
}

