/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSpeedSearch;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTree
extends DnDAwareTree
implements DataProvider,
Disposable {
    private final TransferToEDTQueue<Runnable> myLaterInvocator;
    private final ComponentListener myMoveListener;
    private static final DataKey<XDebuggerTree> XDEBUGGER_TREE_KEY = DataKey.create((String)"xdebugger.tree");
    private final SingleAlarm myAlarm;
    private static final Convertor<TreePath, String> SPEED_SEARCH_CONVERTER = o2 -> {
        Object node;
        String text2 = null;
        if (o2 != null && (node = o2.getLastPathComponent()) instanceof XDebuggerTreeNode) {
            text2 = ((XDebuggerTreeNode)node).getText().toString();
        }
        return StringUtil.notNullize(text2);
    };
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c2) {
            if (!(c2 instanceof XDebuggerTree)) {
                return null;
            }
            XDebuggerTree tree2 = (XDebuggerTree)((Object)c2);
            TreePath[] selectedPaths = tree2.getSelectionPaths();
            if (selectedPaths == null || selectedPaths.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (TreePath path : selectedPaths) {
                htmlBuf.append("  <li>");
                Object node = path.getLastPathComponent();
                if (node != null) {
                    if (node instanceof XDebuggerTreeNode) {
                        ((XDebuggerTreeNode)node).appendToComponent(coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text2 = node.toString();
                        plainBuf.append(text2);
                        htmlBuf.append(text2);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf.toString(), plainBuf.toString());
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 1;
        }
    };
    private final DefaultTreeModel myTreeModel;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private XSourcePosition mySourcePosition;
    private final List<XDebuggerTreeListener> myListeners;
    private final XValueMarkers<?, ?> myValueMarkers;
    private final TreeExpansionListener myTreeExpansionListener;

    public XDebuggerTree(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, final @NotNull String popupActionGroupId, @Nullable XValueMarkers<?, ?> valueMarkers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        if (popupActionGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActionGroupId", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        this.myLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"XDebuggerTree later invocator", (int)100);
        this.myMoveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e2) {
                XDebuggerTree.this.repaint();
            }
        };
        this.myAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                Editor editor = FileEditorManager.getInstance((Project)XDebuggerTree.this.myProject).getSelectedTextEditor();
                if (editor != null) {
                    editor.getContentComponent().revalidate();
                    editor.getContentComponent().repaint();
                }
            }
        }, 100, this);
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myValueMarkers = valueMarkers;
        this.myProject = project2;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myTreeModel = new DefaultTreeModel(null);
        this.setModel(this.myTreeModel);
        this.setCellRenderer((TreeCellRenderer)((Object)new XDebuggerTreeRenderer()));
        new TreeLinkMouseListener(new XDebuggerTreeRenderer()){

            @Override
            protected boolean doCacheLastNode() {
                return false;
            }

            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$4", "handleTagClick"));
                }
                if (tag instanceof XDebuggerTreeNodeHyperlink) {
                    ((XDebuggerTreeNodeHyperlink)tag).onClick(event);
                }
            }
        }.installOn((Component)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e2) {
                return XDebuggerTree.this.expandIfEllipsis();
            }
        }.installOn((Component)((Object)this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                int key = e2.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XDebuggerTree.this.expandIfEllipsis();
                }
            }
        });
        if (Boolean.valueOf(System.getProperty("xdebugger.variablesView.rss")).booleanValue()) {
            new XDebuggerTreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        } else {
            new TreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        }
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x2, int y2) {
                ActionGroup group = (ActionGroup)actionManager.getAction(popupActionGroupId);
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x2, y2);
            }
        });
        this.registerShortcuts();
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.addComponentListener(this.myMoveListener);
        this.myTreeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.handleExpansion(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.handleExpansion(event, false);
            }

            private void handleExpansion(TreeExpansionEvent event, boolean expanded) {
                Object component;
                TreePath path = event.getPath();
                Object object = component = path != null ? path.getLastPathComponent() : null;
                if (component instanceof XValueGroupNodeImpl) {
                    ((XValueGroupNodeImpl)component).onExpansion(expanded);
                }
            }
        };
        this.addTreeExpansionListener(this.myTreeExpansionListener);
    }

    public void updateEditor() {
        this.myAlarm.cancelAndRequest();
    }

    public boolean isUnderRemoteDebug() {
        DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)this));
        ExecutionEnvironment env = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(context2);
        return env != null && env.getRunProfile() instanceof RemoteRunProfile;
    }

    private boolean expandIfEllipsis() {
        TreeNode parent;
        MessageTreeNode node;
        MessageTreeNode[] treeNodes = (MessageTreeNode[])this.getSelectedNodes(MessageTreeNode.class, null);
        if (treeNodes.length == 1 && (node = treeNodes[0]).isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
            ((XValueContainerNode)parent).startComputingChildren();
            return true;
        }
        return false;
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "addTreeListener"));
        }
        this.myListeners.add(listener2);
    }

    public void removeTreeListener(@NotNull XDebuggerTreeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "removeTreeListener"));
        }
        this.myListeners.remove(listener2);
    }

    public void setRoot(XDebuggerTreeNode root, boolean rootVisible) {
        this.setRootVisible(rootVisible);
        this.myTreeModel.setRoot(root);
    }

    public XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.myTreeModel.getRoot();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "getEditorsProvider"));
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "getProject"));
        }
        return project2;
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        return this.myValueMarkers;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        XValueNodeImpl[] selectedNodes;
        if (XDEBUGGER_TREE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId) && (selectedNodes = (XValueNodeImpl[])this.getSelectedNodes(XValueNodeImpl.class, null)).length == 1 && selectedNodes[0].getFullValueEvaluator() == null) {
            return DebuggerUIUtil.getNodeRawValue(selectedNodes[0]);
        }
        return null;
    }

    public void rebuildAndRestore(XDebuggerTreeState treeState) {
        Object rootNode = this.myTreeModel.getRoot();
        if (rootNode instanceof XDebuggerTreeNode) {
            ((XDebuggerTreeNode)rootNode).clearChildren();
            if (this.isRootVisible() && rootNode instanceof XValueNodeImpl) {
                ((XValue)((XValueNodeImpl)rootNode).getValueContainer()).computePresentation((XValueNode)rootNode, XValuePlace.TREE);
            }
            treeState.restoreState(this);
            this.repaint();
        }
    }

    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children2, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "childrenLoaded"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "childrenLoaded"));
        }
        for (XDebuggerTreeListener listener2 : this.myListeners) {
            listener2.childrenLoaded(node, children2, last);
        }
    }

    public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "nodeLoaded"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "nodeLoaded"));
        }
        for (XDebuggerTreeListener listener2 : this.myListeners) {
            listener2.nodeLoaded(node, name);
        }
    }

    public void markNodesObsolete() {
        Object root = this.myTreeModel.getRoot();
        if (root instanceof XValueContainerNode) {
            XDebuggerTree.markNodesObsolete((XValueContainerNode)root);
        }
    }

    public void dispose() {
        this.setModel(null);
        this.myTreeModel.setRoot(null);
        this.setCellRenderer(null);
        UIUtil.dispose((Component)((Object)this));
        this.setLeadSelectionPath(null);
        this.setAnchorSelectionPath(null);
        this.removeComponentListener(this.myMoveListener);
        this.removeTreeExpansionListener(this.myTreeExpansionListener);
        this.myListeners.clear();
    }

    private void registerShortcuts() {
        DebuggerUIUtil.registerActionOnComponent("XDebugger.SetValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToTypeSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("Debugger.MarkObject", (JComponent)((Object)this), this);
    }

    private static void markNodesObsolete(XValueContainerNode<?> node) {
        node.setObsolete();
        node.getLoadedChildren().forEach(XDebuggerTree::markNodesObsolete);
    }

    @Nullable
    public static XDebuggerTree getTree(AnActionEvent e2) {
        return (XDebuggerTree)((Object)e2.getData(XDEBUGGER_TREE_KEY));
    }

    @Nullable
    public static XDebuggerTree getTree(DataContext context2) {
        return (XDebuggerTree)((Object)XDEBUGGER_TREE_KEY.getData(context2));
    }

    public TransferToEDTQueue<Runnable> getLaterInvocator() {
        return this.myLaterInvocator;
    }

    public void selectNodeOnLoad(final Condition<TreeNode> nodeFilter) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, String name) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$9", "nodeLoaded"));
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.setSelectionPath(node.getPath());
                    XDebuggerTree.this.removeTreeListener(this);
                }
            }
        });
    }

    public void expandNodesOnLoad(final Condition<TreeNode> nodeFilter) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, String name) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$10", "nodeLoaded"));
                }
                if (nodeFilter.value((Object)node) && !node.isLeaf()) {
                    node.getChildCount();
                }
            }

            @Override
            public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children2, boolean last) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$10", "childrenLoaded"));
                }
                if (children2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$10", "childrenLoaded"));
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.expandPath(node.getPath());
                }
            }
        });
    }

    public boolean isDetached() {
        return DataManager.getInstance().getDataContext((Component)((Object)this)).getData(XDebugSessionTab.TAB_KEY) == null;
    }
}

