/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeSpeedSearch
extends TreeSpeedSearch {
    public XDebuggerTreeSpeedSearch(XDebuggerTree tree2, Convertor<TreePath, String> toStringConvertor) {
        super(tree2, toStringConvertor, true);
    }

    @Override
    @Nullable
    protected Object findElement(String s2) {
        String string2 = s2.trim();
        XDebuggerTreeNode node = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getLastSelectedPathComponent(), XDebuggerTreeNode.class);
        if (node == null && (node = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class)) == null) {
            return null;
        }
        return this.findPath(string2, node, true);
    }

    private Object findPath(String string2, XDebuggerTreeNode node, boolean checkChildren) {
        TreePath result2;
        TreePath result3;
        int nodeIndex;
        List<? extends TreeNode> parentChildren;
        TreePath path = node.getPath();
        if (this.isMatchingElement(path, string2)) {
            return path;
        }
        XDebuggerTreeNode parent = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)node.getParent(), XDebuggerTreeNode.class);
        if (parent != null) {
            parentChildren = parent.getChildren();
            nodeIndex = parentChildren.indexOf(node);
            if (nodeIndex != -1) {
                int i2;
                for (i2 = nodeIndex + 1; i2 < parentChildren.size(); ++i2) {
                    result3 = this.match(parentChildren.get(i2), string2);
                    if (result3 == null) continue;
                    return result3;
                }
                for (i2 = nodeIndex - 1; i2 >= 0; --i2) {
                    result3 = this.match(parentChildren.get(i2), string2);
                    if (result3 == null) continue;
                    return result3;
                }
            }
        } else {
            nodeIndex = -1;
            parentChildren = null;
        }
        if (checkChildren && !node.isLeaf() && (result2 = this.findInChildren(node, string2)) != null) {
            return result2;
        }
        if (parent != null) {
            int i3;
            for (i3 = nodeIndex + 1; i3 < parentChildren.size(); ++i3) {
                result3 = this.findInChildren(parentChildren.get(i3), string2);
                if (result3 == null) continue;
                return result3;
            }
            for (i3 = nodeIndex - 1; i3 >= 0; --i3) {
                result3 = this.findInChildren(parentChildren.get(i3), string2);
                if (result3 == null) continue;
                return result3;
            }
            return this.findPath(string2, parent, false);
        }
        return null;
    }

    private TreePath findInChildren(TreeNode node, String string2) {
        if (node.isLeaf() || !(node instanceof XDebuggerTreeNode)) {
            return null;
        }
        LinkedList<XDebuggerTreeNode> queue2 = new LinkedList<XDebuggerTreeNode>();
        queue2.addLast((XDebuggerTreeNode)node);
        int initialLevel = ((XDebuggerTreeNode)node).getPath().getPathCount();
        while (!queue2.isEmpty()) {
            XDebuggerTreeNode p2 = (XDebuggerTreeNode)queue2.removeFirst();
            if (p2.getPath().getPathCount() - initialLevel > 3) {
                return null;
            }
            List<? extends TreeNode> children2 = p2.getChildren();
            if (children2.isEmpty()) continue;
            for (TreeNode treeNode : children2) {
                if (!(treeNode instanceof XDebuggerTreeNode)) continue;
                TreePath result2 = this.match(treeNode, string2);
                if (result2 != null) {
                    return result2;
                }
                if (treeNode.isLeaf()) continue;
                queue2.addLast((XDebuggerTreeNode)treeNode);
            }
        }
        return null;
    }

    @Nullable
    private TreePath match(TreeNode node, String string2) {
        TreePath path = node instanceof XDebuggerTreeNode ? ((XDebuggerTreeNode)node).getPath() : null;
        return this.isMatchingElement(path, string2) ? path : null;
    }
}

