/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTreeState {
    private final NodeInfo myRootInfo;
    private Rectangle myLastVisibleNodeRect;

    private XDebuggerTreeState(@NotNull XDebuggerTree tree2) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "<init>"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeNode root = tree2.getRoot();
        NodeInfo nodeInfo = this.myRootInfo = root != null ? new NodeInfo("", "", tree2.isPathSelected(root.getPath())) : null;
        if (root != null) {
            this.addChildren(tree2, this.myRootInfo, root);
        }
    }

    public XDebuggerTreeRestorer restoreState(@NotNull XDebuggerTree tree2) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "restoreState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeRestorer restorer = null;
        if (this.myRootInfo != null) {
            restorer = new XDebuggerTreeRestorer(tree2, this.myLastVisibleNodeRect);
            restorer.restore(tree2.getRoot(), this.myRootInfo);
        }
        return restorer;
    }

    public static XDebuggerTreeState saveState(@NotNull XDebuggerTree tree2) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "saveState"));
        }
        return new XDebuggerTreeState(tree2);
    }

    private void addChildren(XDebuggerTree tree2, NodeInfo nodeInfo, XDebuggerTreeNode treeNode) {
        if (tree2.isExpanded(treeNode.getPath())) {
            List<? extends XDebuggerTreeNode> children2 = treeNode.getLoadedChildren();
            nodeInfo.myExpanded = true;
            for (XDebuggerTreeNode xDebuggerTreeNode : children2) {
                NodeInfo childInfo;
                TreePath path = xDebuggerTreeNode.getPath();
                Rectangle bounds = tree2.getPathBounds(path);
                if (bounds != null) {
                    Rectangle treeVisibleRect;
                    Rectangle rectangle = treeVisibleRect = tree2.getParent() instanceof JViewport ? ((JViewport)tree2.getParent()).getViewRect() : tree2.getVisibleRect();
                    if (treeVisibleRect.contains(bounds)) {
                        this.myLastVisibleNodeRect = bounds;
                    }
                }
                if ((childInfo = XDebuggerTreeState.createNode(xDebuggerTreeNode, tree2.isPathSelected(path))) == null) continue;
                nodeInfo.addChild(childInfo);
                this.addChildren(tree2, childInfo, xDebuggerTreeNode);
            }
        }
    }

    @Nullable
    private static NodeInfo createNode(XDebuggerTreeNode node, boolean selected) {
        RestorableStateNode valueNode;
        if (node instanceof RestorableStateNode && (valueNode = (RestorableStateNode)((Object)node)).isComputed()) {
            return new NodeInfo(valueNode.getName(), valueNode.getRawValue(), selected);
        }
        return null;
    }

    public static class NodeInfo {
        private final String myName;
        private final String myValue;
        private boolean myExpanded;
        private final boolean mySelected;
        private MultiMap<String, NodeInfo> myChildren;

        public NodeInfo(String name, String value2, boolean selected) {
            this.myName = name;
            this.myValue = value2;
            this.mySelected = selected;
        }

        public void addChild(@NotNull NodeInfo child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo", "addChild"));
            }
            if (this.myChildren == null) {
                this.myChildren = new MultiMap();
            }
            this.myChildren.putValue((Object)child.myName, (Object)child);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public String getValue() {
            return this.myValue;
        }

        @Nullable
        public NodeInfo getChild(XNamedTreeNode node) {
            TreeNode parent;
            String name = node.getName();
            if (this.myChildren == null) {
                return null;
            }
            List infos = (List)this.myChildren.get((Object)name);
            if (infos.size() > 1 && (parent = node.getParent()) instanceof XDebuggerTreeNode) {
                int idx = 0;
                for (XDebuggerTreeNode xDebuggerTreeNode : ((XDebuggerTreeNode)parent).getLoadedChildren()) {
                    if (xDebuggerTreeNode == node) break;
                    if (!(xDebuggerTreeNode instanceof XNamedTreeNode) || !Comparing.equal((String)((XNamedTreeNode)xDebuggerTreeNode).getName(), (String)name)) continue;
                    ++idx;
                }
                if (idx < infos.size()) {
                    return (NodeInfo)infos.get(idx);
                }
            }
            return (NodeInfo)ContainerUtil.getFirstItem((List)infos);
        }
    }
}

