/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeActionBase
extends AnAction {
    public void actionPerformed(AnActionEvent e2) {
        String nodeName;
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e2.getDataContext());
        if (node != null && (nodeName = node.getName()) != null) {
            this.perform(node, nodeName, e2);
        }
    }

    protected abstract void perform(XValueNodeImpl var1, @NotNull String var2, AnActionEvent var3);

    public void update(AnActionEvent e2) {
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e2.getDataContext());
        e2.getPresentation().setEnabled(node != null && this.isEnabled(node, e2));
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "isEnabled"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "isEnabled"));
        }
        return node.getName() != null;
    }

    @NotNull
    public static List<XValueNodeImpl> getSelectedNodes(DataContext dataContext) {
        XDebuggerTree tree2 = XDebuggerTree.getTree(dataContext);
        if (tree2 == null) {
            List<XValueNodeImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "getSelectedNodes"));
            }
            return list2;
        }
        Object[] paths = tree2.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            List<XValueNodeImpl> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "getSelectedNodes"));
            }
            return list3;
        }
        List list4 = StreamEx.of((Object[])paths).map(TreePath::getLastPathComponent).select(XValueNodeImpl.class).toList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "getSelectedNodes"));
        }
        return list4;
    }

    @Nullable
    public static XValueNodeImpl getSelectedNode(DataContext dataContext) {
        XDebuggerTree tree2 = XDebuggerTree.getTree(dataContext);
        if (tree2 == null) {
            return null;
        }
        TreePath path = tree2.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        return node instanceof XValueNodeImpl ? (XValueNodeImpl)node : null;
    }

    @Nullable
    public static XValue getSelectedValue(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "getSelectedValue"));
        }
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(dataContext);
        return node != null ? (XValue)node.getValueContainer() : null;
    }
}

