/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchesRootNode
extends XValueContainerNode<XValueContainer> {
    private final XWatchesView myWatchesView;
    private final List<WatchNodeImpl> myChildren;

    public WatchesRootNode(@NotNull XDebuggerTree tree2, @NotNull XWatchesView watchesView, @NotNull XExpression[] expressions) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (watchesView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchesView", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        this(tree2, watchesView, expressions, null, false);
    }

    public WatchesRootNode(@NotNull XDebuggerTree tree2, @NotNull XWatchesView watchesView, @NotNull XExpression[] expressions, final @Nullable XStackFrame stackFrame, final boolean watchesInVariables) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (watchesView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchesView", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        super(tree2, null, new XValueContainer(){

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$1", "computeChildren"));
                }
                if (stackFrame != null && watchesInVariables) {
                    stackFrame.computeChildren(node);
                } else {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }
        });
        this.setLeaf(false);
        this.myWatchesView = watchesView;
        this.myChildren = ContainerUtil.newArrayList();
        for (XExpression watchExpression : expressions) {
            this.myChildren.add(new WatchNodeImpl(this.myTree, this, watchExpression, stackFrame));
        }
    }

    @Override
    @NotNull
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List list2 = ContainerUtil.concat(this.myChildren, super.getLoadedChildren());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "getLoadedChildren"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List<TreeNode> children2 = super.getChildren();
        List list2 = ContainerUtil.concat(this.myChildren, children2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "getChildren"));
        }
        return list2;
    }

    @NotNull
    public List<? extends WatchNode> getAllChildren() {
        List<? extends WatchNode> list2 = this.getWatchChildren();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "getAllChildren"));
        }
        return list2;
    }

    @NotNull
    public List<? extends WatchNode> getWatchChildren() {
        List<WatchNodeImpl> list2 = this.myChildren;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "getWatchChildren"));
        }
        return list2;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.myChildren.clear();
    }

    public void computeWatches() {
        this.myChildren.forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    @Deprecated
    public void addWatchExpression(@Nullable XDebuggerEvaluator evaluator2, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "addWatchExpression"));
        }
        this.addWatchExpression((XStackFrame)null, expression, index, navigateToWatchNode);
    }

    public void addWatchExpression(@Nullable XStackFrame stackFrame, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "addWatchExpression"));
        }
        WatchNodeImpl message2 = new WatchNodeImpl(this.myTree, this, expression, stackFrame);
        if (index == -1) {
            this.myChildren.add(message2);
            index = this.myChildren.size() - 1;
        } else {
            this.myChildren.add(index, message2);
        }
        this.fireNodeInserted(index);
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message2);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message2.getPath());
        }
    }

    private void fireNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this, new int[]{index});
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        return this.removeChildNode(this.myChildren, node);
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        int[] indices = this.getNodesIndices(nodes);
        TreeNode[] removed = this.getChildNodes(indices);
        this.myChildren.removeAll(nodes);
        this.fireNodesRemoved(indices, removed);
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.fireNodeStructureChanged();
    }

    public void moveUp(WatchNode node) {
        int index = this.getIndex(node);
        if (index > 0) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index - 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index - 1);
    }

    public void moveDown(WatchNode node) {
        int index = this.getIndex(node);
        if (index < this.myChildren.size() - 1) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index + 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index + 1);
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNodeImpl node) {
        WatchNodeImpl messageNode;
        int index;
        int n2 = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            int selectedIndex = this.myChildren.indexOf(ArrayUtil.getFirstElement((Object[])this.myTree.getSelectedNodes(WatchNodeImpl.class, null)));
            int targetIndex = selectedIndex == -1 ? this.myChildren.size() : selectedIndex + 1;
            messageNode = new WatchNodeImpl(this.myTree, this, XExpressionImpl.EMPTY_EXPRESSION, null);
            this.myChildren.add(targetIndex, messageNode);
            this.fireNodeInserted(targetIndex);
            this.getTree().setSelectionRows(ArrayUtil.EMPTY_INT_ARRAY);
        } else {
            messageNode = node;
        }
        new WatchInplaceEditor(this, this.myWatchesView, messageNode, node).show();
    }
}

