/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueTextRendererImpl
extends XValueTextRendererBase {
    private final ColoredTextContainer myText;

    public XValueTextRendererImpl(@NotNull ColoredTextContainer text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "<init>"));
        }
        this.myText = text2;
    }

    public void renderValue(@NotNull String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderValue"));
        }
        XValuePresentationUtil.renderValue(value2, this.myText, SimpleTextAttributes.REGULAR_ATTRIBUTES, -1, null);
    }

    @Override
    protected void renderRawValue(@NotNull String value2, @NotNull TextAttributesKey key) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderRawValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderRawValue"));
        }
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(key);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append(value2, attributes);
    }

    public void renderStringValue(@NotNull String value2, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderStringValue"));
        }
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.STRING);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append("\"", attributes);
        XValuePresentationUtil.renderValue(value2, this.myText, attributes, maxLength, additionalSpecialCharsToHighlight);
        this.myText.append("\"", attributes);
    }

    public void renderComment(@NotNull String comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderComment"));
        }
        this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public void renderError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderError"));
        }
        this.myText.append(error, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public void renderSpecialSymbol(@NotNull String symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl", "renderSpecialSymbol"));
        }
        this.myText.append(symbol, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

