/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlExtension
extends XmlExtension {
    public static final XmlExtension DEFAULT_EXTENSION = new DefaultXmlExtension();
    private static final Logger LOG = Logger.getInstance(DefaultXmlExtension.class);

    @Override
    public boolean isAvailable(PsiFile file2) {
        return true;
    }

    @Override
    @NotNull
    public List<XmlExtension.TagInfo> getAvailableTagNames(@NotNull XmlFile file2, @NotNull XmlTag context2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        HashSet<String> namespaces = new HashSet<String>(Arrays.asList(context2.knownNamespaces()));
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)file2);
        for (XmlSchemaProvider provider : providers) {
            namespaces.addAll(provider.getAvailableNamespaces(file2, null));
        }
        ArrayList<String> nsInfo = new ArrayList<String>();
        List<XmlElementDescriptor> descriptors = TagNameVariantCollector.getTagDescriptors(context2, namespaces, nsInfo);
        ArrayList<XmlExtension.TagInfo> set2 = new ArrayList<XmlExtension.TagInfo>();
        for (int i2 = 0; i2 < descriptors.size(); ++i2) {
            final XmlElementDescriptor descriptor2 = descriptors.get(i2);
            String qualifiedName = descriptor2.getName((PsiElement)context2);
            LOG.assertTrue(qualifiedName != null, (Object)(descriptor2 + " returned null name"));
            int pos = qualifiedName.indexOf(58);
            String name = pos >= 0 ? qualifiedName.substring(pos + 1) : qualifiedName;
            set2.add(new XmlExtension.TagInfo(name, (String)nsInfo.get(i2)){

                @Override
                @Nullable
                public PsiElement getDeclaration() {
                    return descriptor2.getDeclaration();
                }
            });
        }
        ArrayList<XmlExtension.TagInfo> arrayList = set2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        return arrayList;
    }

    public static Set<String> filterNamespaces(Set<String> namespaces, String tagName2, XmlFile context2) {
        if (tagName2 == null) {
            return namespaces;
        }
        HashSet<String> set2 = new HashSet<String>();
        block0: for (String namespace : namespaces) {
            XmlElementDescriptor[] elementDescriptors;
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)context2, namespace);
            if (xmlFile == null) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            assert (nsDescriptor != null);
            for (XmlElementDescriptor elementDescriptor : elementDescriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                LOG.assertTrue(elementDescriptor != null, (Object)("Null returned from " + nsDescriptor));
                if (!DefaultXmlExtension.hasTag(elementDescriptor, tagName2, new HashSet<XmlElementDescriptor>())) continue;
                set2.add(namespace);
                continue block0;
            }
        }
        return set2;
    }

    private static boolean hasTag(@NotNull XmlElementDescriptor elementDescriptor, String tagName2, Set<XmlElementDescriptor> visited) {
        if (elementDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDescriptor", "com/intellij/xml/DefaultXmlExtension", "hasTag"));
        }
        String name = elementDescriptor.getDefaultName();
        if (name == null) {
            LOG.error(elementDescriptor + " returned null as default name");
            return false;
        }
        if (name.equals(tagName2)) {
            return true;
        }
        for (XmlElementDescriptor descriptor2 : elementDescriptor.getElementsDescriptors(null)) {
            if (visited.contains(elementDescriptor)) continue;
            visited.add(elementDescriptor);
            if (!DefaultXmlExtension.hasTag(descriptor2, tagName2, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SchemaPrefix getPrefixDeclaration(XmlTag context2, String namespacePrefix) {
        String nsDeclarationAttrName = null;
        for (XmlTag t2 = context2; t2 != null; t2 = t2.getParentTag()) {
            XmlAttribute attribute;
            if (!t2.hasNamespaceDeclarations()) continue;
            if (nsDeclarationAttrName == null) {
                String string2 = nsDeclarationAttrName = namespacePrefix.length() > 0 ? "xmlns:" + namespacePrefix : "xmlns";
            }
            if ((attribute = t2.getAttribute(nsDeclarationAttrName)) == null) continue;
            String attrPrefix = attribute.getNamespacePrefix();
            TextRange textRange = TextRange.from((int)(attrPrefix.length() + 1), (int)namespacePrefix.length());
            return new SchemaPrefix(attribute, textRange, namespacePrefix);
        }
        return null;
    }
}

