/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public abstract class Html5SchemaProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.Html5SchemaProvider");
    public static final ExtensionPointName<Html5SchemaProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.xml.html5SchemaProvider");
    private static String HTML5_SCHEMA_LOCATION;
    private static String XHTML5_SCHEMA_LOCATION;
    private static String CHARS_DTD_LOCATION;
    private static boolean ourInitialized;

    public static String getHtml5SchemaLocation() {
        Html5SchemaProvider.ensureInitialized();
        return HTML5_SCHEMA_LOCATION;
    }

    public static String getXhtml5SchemaLocation() {
        Html5SchemaProvider.ensureInitialized();
        return XHTML5_SCHEMA_LOCATION;
    }

    public static String getCharsDtdLocation() {
        Html5SchemaProvider.ensureInitialized();
        return CHARS_DTD_LOCATION;
    }

    private static synchronized void ensureInitialized() {
        URL dtdCharsLocationURL;
        URL xhtmlSchemaLocationURL;
        URL htmlSchemaLocationURL;
        if (ourInitialized) {
            return;
        }
        ourInitialized = true;
        Html5SchemaProvider[] providers = (Html5SchemaProvider[])EP_NAME.getExtensions();
        if (providers.length > 1) {
            LOG.error("More than one HTML5 schema providers found: " + Html5SchemaProvider.getClassesListString(providers));
        }
        if (providers.length > 0) {
            htmlSchemaLocationURL = providers[0].getHtmlSchemaLocation();
            xhtmlSchemaLocationURL = providers[0].getXhtmlSchemaLocation();
            dtdCharsLocationURL = providers[0].getCharsLocation();
        } else {
            LOG.info("RelaxNG based schema for HTML5 is not supported. Old XSD schema will be used");
            xhtmlSchemaLocationURL = htmlSchemaLocationURL = Html5SchemaProvider.class.getResource("/standardSchemas/html5/xhtml5.xsd");
            dtdCharsLocationURL = htmlSchemaLocationURL;
        }
        HTML5_SCHEMA_LOCATION = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)htmlSchemaLocationURL.toExternalForm())));
        LOG.info("HTML5_SCHEMA_LOCATION = " + Html5SchemaProvider.getHtml5SchemaLocation());
        XHTML5_SCHEMA_LOCATION = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)xhtmlSchemaLocationURL.toExternalForm())));
        LOG.info("XHTML5_SCHEMA_LOCATION = " + Html5SchemaProvider.getXhtml5SchemaLocation());
        CHARS_DTD_LOCATION = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)dtdCharsLocationURL.toExternalForm())));
        LOG.info("CHARS_DTD_LOCATION = " + Html5SchemaProvider.getCharsDtdLocation());
    }

    @NotNull
    public abstract URL getHtmlSchemaLocation();

    @NotNull
    public abstract URL getXhtmlSchemaLocation();

    @NotNull
    public abstract URL getCharsLocation();

    private static <T> String getClassesListString(T[] a) {
        StringBuilder builder = new StringBuilder();
        int n2 = a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T element = a[i2];
            builder.append(element != null ? element.getClass().getName() : "NULL");
            if (i2 >= n2 - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

