/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ParameterizedCachedValueImpl;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import io.netty.util.collection.IntObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    private static ParameterizedCachedValueImpl<IntObjectHashMap<String>, PsiFile> ESCAPES = new ParameterizedCachedValueImpl<IntObjectHashMap<String>, PsiFile>((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<IntObjectHashMap<String>, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<IntObjectHashMap<String>> compute(PsiFile param) {
            XmlFile file2 = XmlUtil.findXmlFile(param, Html5SchemaProvider.getCharsDtdLocation());
            assert (file2 != null);
            final IntObjectHashMap result2 = new IntObjectHashMap();
            XmlUtil.processXmlElements((XmlElement)file2, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    String value2;
                    Integer key;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/actions/EscapeEntitiesAction$1$1", "execute"));
                    }
                    if (element instanceof XmlEntityDecl && !result2.containsKey((Object)(key = Integer.valueOf((value2 = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value2.length() - 1))))) {
                        result2.put(key, (Object)((XmlEntityDecl)element).getName());
                    }
                    return true;
                }
            }, true);
            return new CachedValueProvider.Result((Object)result2, new Object[]{ModificationTracker.NEVER_CHANGED});
        }
    }){

        @Override
        public boolean isFromMyProject(Project project2) {
            return true;
        }
    };

    private static String escape(XmlFile file2, String text2, int start2) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            String escape;
            char c2 = text2.charAt(i2);
            PsiElement element = file2.findElementAt(start2 + i2);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c2 == '<' || c2 == '>' || c2 == '&' || c2 == '\"' || c2 == '\'' || c2 > '\u007f') && (escape = (String)ESCAPES.getValue((PsiFile)file2).get((int)c2)) != null) {
                result2.append("&").append(escape).append(";");
                continue;
            }
            result2.append(c2);
        }
        return result2.toString();
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        return file2 instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/actions/EscapeEntitiesAction", "getHandler"));
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        for (int i2 = starts.length - 1; i2 >= 0; --i2) {
            String newText;
            int start2 = starts[i2];
            int end = ends[i2];
            String oldText = document.getText(new TextRange(start2, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape((XmlFile)file2, oldText, start2))) continue;
            document.replaceString(start2, end, (CharSequence)newText);
        }
    }
}

