/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.actions.SimpleCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateXmlTagAction
extends SimpleCodeInsightAction {
    public static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(GenerateXmlTagAction.class);

    public void invoke(final @NotNull Project project2, final @NotNull Editor editor, final @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        try {
            final XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
            if (contextTag == null) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Caret should be positioned inside a tag");
            }
            XmlElementDescriptor currentTagDescriptor = contextTag.getDescriptor();
            assert (currentTagDescriptor != null);
            Object[] descriptors = currentTagDescriptor.getElementsDescriptors(contextTag);
            Arrays.sort(descriptors, Comparator.comparing(PsiMetaData::getName));
            JBList list2 = new JBList(descriptors);
            list2.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
            Runnable runnable2 = () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/GenerateXmlTagAction", "lambda$invoke$0"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/GenerateXmlTagAction", "lambda$invoke$0"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "lambda$invoke$0"));
                }
                final XmlElementDescriptor selected = (XmlElementDescriptor)list2.getSelectedValue();
                new WriteCommandAction.Simple(project2, "Generate XML Tag", new PsiFile[]{file2}){

                    protected void run() {
                        if (selected == null) {
                            return;
                        }
                        XmlTag newTag = GenerateXmlTagAction.createTag(contextTag, selected);
                        XmlTag anchor = GenerateXmlTagAction.getAnchor(contextTag, editor, selected);
                        if (anchor == null) {
                            int offset = editor.getCaretModel().getOffset();
                            Document document = editor.getDocument();
                            document.insertString(offset, (CharSequence)newTag.getText());
                            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                            newTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset + 1), XmlTag.class, (boolean)false);
                        } else {
                            newTag = (XmlTag)contextTag.addAfter((PsiElement)newTag, (PsiElement)anchor);
                        }
                        if (newTag != null) {
                            GenerateXmlTagAction.generateTag(newTag, editor);
                        }
                    }
                }.execute();
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                XmlElementDescriptor descriptor2 = (XmlElementDescriptor)ContainerUtil.find((Object[])descriptors, xmlElementDescriptor -> xmlElementDescriptor.getName().equals(TEST_THREAD_LOCAL.get()));
                list2.setSelectedValue((Object)descriptor2, false);
                runnable2.run();
            } else {
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Tag Name").setItemChoosenCallback(runnable2).setFilteringEnabled(o2 -> ((XmlElementDescriptor)o2).getName()).createPopup().showInBestPositionFor(editor);
            }
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException e2) {
            HintManager.getInstance().showErrorHint(editor, e2.getMessage());
        }
    }

    @Nullable
    private static XmlTag getAnchor(@NotNull XmlTag contextTag, Editor editor, XmlElementDescriptor selected) {
        if (contextTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextTag", "com/intellij/xml/actions/GenerateXmlTagAction", "getAnchor"));
        }
        XmlContentDFA contentDFA = XmlContentDFA.getContentDFA(contextTag);
        int offset = editor.getCaretModel().getOffset();
        if (contentDFA == null) {
            return null;
        }
        XmlTag anchor = null;
        boolean previousPositionIsPossible = true;
        for (XmlTag subTag : contextTag.getSubTags()) {
            if (contentDFA.getPossibleElements().contains(selected)) {
                if (subTag.getTextOffset() > offset) break;
                anchor = subTag;
                previousPositionIsPossible = true;
            } else {
                previousPositionIsPossible = false;
            }
            contentDFA.transition(subTag);
        }
        return previousPositionIsPossible ? null : anchor;
    }

    public static void generateTag(@NotNull XmlTag newTag, Editor editor) {
        if (newTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTag", "com/intellij/xml/actions/GenerateXmlTagAction", "generateTag"));
        }
        GenerateXmlTagAction.generateRaw(newTag);
        XmlTag restored = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newTag);
        if (restored == null) {
            LOG.error("Could not restore tag: " + newTag.getText());
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)restored);
        GenerateXmlTagAction.replaceElements(restored, builder);
        builder.run(editor, false);
    }

    private static void generateRaw(@NotNull XmlTag newTag) {
        if (newTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTag", "com/intellij/xml/actions/GenerateXmlTagAction", "generateRaw"));
        }
        XmlElementDescriptor selected = newTag.getDescriptor();
        if (selected == null) {
            return;
        }
        switch (selected.getContentType()) {
            case 0: {
                newTag.collapseIfEmpty();
                ASTNode node = newTag.getNode();
                assert (node != null);
                ASTNode elementEnd = node.findChildByType(XmlTokenType.XML_EMPTY_ELEMENT_END);
                if (elementEnd != null) break;
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, newTag.getManager());
                node.addChild((ASTNode)emptyTagEnd);
                break;
            }
            case 3: {
                newTag.getValue().setText("");
            }
        }
        for (ASTNode descriptor2 : selected.getAttributesDescriptors(newTag)) {
            if (!descriptor2.isRequired()) continue;
            newTag.setAttribute(descriptor2.getName(), "");
        }
        List<XmlElementDescriptor> tags = GenerateXmlTagAction.getRequiredSubTags(selected);
        for (XmlElementDescriptor descriptor3 : tags) {
            if (descriptor3 == null) {
                XmlTag tag = XmlElementFactory.getInstance((Project)newTag.getProject()).createTagFromText((CharSequence)"<", newTag.getLanguage());
                newTag.addSubTag(tag, false);
                continue;
            }
            XmlTag subTag = newTag.addSubTag(GenerateXmlTagAction.createTag(newTag, descriptor3), false);
            GenerateXmlTagAction.generateRaw(subTag);
        }
    }

    public static List<XmlElementDescriptor> getRequiredSubTags(XmlElementDescriptor selected) {
        XmlElementsGroup topGroup = selected.getTopGroup();
        if (topGroup == null) {
            return Collections.emptyList();
        }
        return GenerateXmlTagAction.computeRequiredSubTags(topGroup);
    }

    private static void replaceElements(XmlTag tag, TemplateBuilder builder) {
        int i2;
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            XmlAttributeValue value2 = xmlAttribute.getValueElement();
            if (value2 == null) continue;
            builder.replaceElement((PsiElement)value2, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        if ("<".equals(tag.getText())) {
            builder.replaceElement((PsiElement)tag, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteSmartMacro()));
        } else if (tag.getSubTags().length == 0 && (i2 = tag.getText().indexOf("></")) > 0) {
            builder.replaceElement((PsiElement)tag, TextRange.from((int)(i2 + 1), (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            GenerateXmlTagAction.replaceElements((XmlTag)xmlAttribute, builder);
        }
    }

    private static XmlTag createTag(@NotNull XmlTag contextTag, @NotNull XmlElementDescriptor descriptor2) {
        if (contextTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextTag", "com/intellij/xml/actions/GenerateXmlTagAction", "createTag"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/actions/GenerateXmlTagAction", "createTag"));
        }
        String namespace = GenerateXmlTagAction.getNamespace(descriptor2);
        XmlTag tag = contextTag.createChildTag(descriptor2.getName(), namespace, null, false);
        PsiElement lastChild = tag.getLastChild();
        assert (lastChild != null);
        lastChild.delete();
        return tag;
    }

    private static String getNamespace(XmlElementDescriptor descriptor2) {
        return descriptor2 instanceof XmlElementDescriptorImpl ? ((XmlElementDescriptorImpl)descriptor2).getNamespace() : "";
    }

    @Nullable
    private static XmlTag getContextTag(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        XmlTag tag = null;
        if (element != null) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        }
        if (tag == null) {
            tag = ((XmlFile)file2).getRootTag();
        }
        return tag;
    }

    private static List<XmlElementDescriptor> computeRequiredSubTags(XmlElementsGroup group) {
        if (group.getMinOccurs() < 1) {
            return Collections.emptyList();
        }
        switch (group.getGroupType()) {
            case LEAF: {
                XmlElementDescriptor descriptor2 = group.getLeafDescriptor();
                return descriptor2 == null ? Collections.emptyList() : Collections.singletonList(descriptor2);
            }
            case CHOICE: {
                LinkedHashSet<XmlElementDescriptor> set2 = null;
                for (XmlElementsGroup subGroup : group.getSubGroups()) {
                    List<XmlElementDescriptor> descriptors = GenerateXmlTagAction.computeRequiredSubTags(subGroup);
                    if (set2 == null) {
                        set2 = new LinkedHashSet<XmlElementDescriptor>(descriptors);
                        continue;
                    }
                    set2.retainAll(descriptors);
                }
                if (set2 == null || set2.isEmpty()) {
                    return Collections.singletonList(null);
                }
                return new ArrayList<XmlElementDescriptor>(set2);
            }
        }
        ArrayList<XmlElementDescriptor> list2 = new ArrayList<XmlElementDescriptor>();
        for (XmlElementsGroup subGroup : group.getSubGroups()) {
            list2.addAll(GenerateXmlTagAction.computeRequiredSubTags(subGroup));
        }
        return list2;
    }

    private static boolean isInsideTagBody(XmlTag contextTag, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "isInsideTagBody"));
        }
        return contextTag.getValue().getTextRange().contains(editor.getCaretModel().getOffset());
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
        return contextTag != null && GenerateXmlTagAction.isInsideTagBody(contextTag, editor) && contextTag.getDescriptor() != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myNSLabel;

        public MyListCellRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myNSLabel = new JLabel();
            this.myPanel.add((Component)this.myNSLabel, "East");
            EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme2.getFont(EditorFontType.PLAIN);
            this.myNameLabel.setFont(font);
            this.myNSLabel.setFont(font);
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            XmlElementDescriptor descriptor2 = (XmlElementDescriptor)value2;
            Color backgroundColor = isSelected ? list2.getSelectionBackground() : list2.getBackground();
            this.myNameLabel.setText(descriptor2.getName());
            this.myNameLabel.setForeground(isSelected ? list2.getSelectionForeground() : list2.getForeground());
            this.myPanel.setBackground(backgroundColor);
            this.myNSLabel.setText(GenerateXmlTagAction.getNamespace(descriptor2));
            this.myNSLabel.setForeground(LookupCellRenderer.getGrayedForeground(isSelected));
            this.myNSLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

