/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlActionHandler getHandler(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/validate/ValidateXmlAction", "getHandler"));
        }
        ValidateXmlActionHandler handler2 = new ValidateXmlActionHandler(true);
        handler2.setErrorReporter(new StdErrorReporter(handler2, file2.getProject(), () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/validate/ValidateXmlAction", "lambda$getHandler$0"));
            }
            this.doRunAction(file2);
        }));
        return handler2;
    }

    public void actionPerformed(AnActionEvent e2) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e2.getDataContext());
        if (psiFile != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/xml/actions/validate/ValidateXmlAction", "doRunAction"));
        }
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/xml/actions/validate/ValidateXmlAction", "lambda$doRunAction$2"));
            }
            Runnable action2 = () -> {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/xml/actions/validate/ValidateXmlAction", "lambda$null$1"));
                }
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, this.getCommandName(), null);
    }

    private String getCommandName() {
        String text2 = this.getTemplatePresentation().getText();
        return text2 != null ? text2 : "";
    }

    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(event.getDataContext());
        boolean flag = psiElement instanceof XmlFile;
        presentation.setVisible(flag);
        boolean value2 = psiElement instanceof XmlFile;
        if (value2) {
            PsiFile containingFile = psiElement.getContainingFile();
            value2 = containingFile != null && (containingFile.getFileType() == StdFileTypes.XML || containingFile.getFileType() == StdFileTypes.XHTML) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(value2);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(value2);
        }
    }
}

