/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.GenerateSchemaFromInstanceDocumentDialog;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;

public class GenerateSchemaFromInstanceDocumentAction
extends AnAction {
    private static final Map<String, String> DESIGN_TYPES = new HashMap<String, String>();
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();

    public void update(AnActionEvent e2) {
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e2.getDataContext());
        boolean enabled = GenerateSchemaFromInstanceDocumentAction.isAcceptableFile(file2);
        e2.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e2.getPlace())) {
            e2.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e2.getDataContext());
        GenerateSchemaFromInstanceDocumentDialog dialog2 = new GenerateSchemaFromInstanceDocumentDialog(project2, file2);
        dialog2.setOkAction(() -> GenerateSchemaFromInstanceDocumentAction.doAction(project2, dialog2));
        dialog2.show();
    }

    private static void doAction(Project project2, GenerateSchemaFromInstanceDocumentDialog dialog2) {
        VirtualFile xsdVFile;
        boolean renamed;
        FileDocumentManager.getInstance().saveAllDocuments();
        String url = dialog2.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project2, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project2, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("-design");
        parameters.add(DESIGN_TYPES.get(dialog2.getDesignType()));
        parameters.add("-simple-content-types");
        parameters.add(CONTENT_TYPES.get(dialog2.getSimpleContentType()));
        parameters.add("-enumerations");
        String enumLimit = dialog2.getEnumerationsLimit();
        parameters.add("0".equals(enumLimit) ? "never" : enumLimit);
        parameters.add("-outDir");
        String dirPath = relativeFileDir.getPath();
        parameters.add(dirPath);
        File expectedSchemaFile = new File(dirPath + File.separator + relativeFile.getName() + "0.xsd");
        if (expectedSchemaFile.exists() && !expectedSchemaFile.delete()) {
            Messages.showErrorDialog((Project)project2, (String)XmlBundle.message((String)"cant.delete.file", (Object[])new Object[]{expectedSchemaFile.getPath()}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        parameters.add("-outPrefix");
        parameters.add(relativeFile.getName());
        parameters.add(url);
        File xsd = new File(dirPath + File.separator + dialog2.getTargetSchemaName());
        VirtualFile xsdFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd);
        if (xsdFile != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    xsdFile.delete(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        Inst2Xsd.main((String[])ArrayUtil.toStringArray(parameters));
        if (expectedSchemaFile.exists() && !(renamed = expectedSchemaFile.renameTo(xsd))) {
            Messages.showErrorDialog((Project)project2, (String)XmlBundle.message((String)"cant.rename.file", (Object[])new Object[]{expectedSchemaFile.getPath(), xsd.getPath()}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
        if ((xsdVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd)) != null) {
            FileEditorManager.getInstance((Project)project2).openFile(xsdVFile, true);
        } else {
            Messages.showErrorDialog((Project)project2, (String)XmlBundle.message((String)"xml2xsd.generator.error.message", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml2xsd.generator.error", (Object[])new Object[0]));
        }
    }

    public static boolean isAcceptableFile(VirtualFile file2) {
        return file2 != null && "xml".equalsIgnoreCase(file2.getExtension());
    }

    static {
        DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.LOCAL_ELEMENTS_GLOBAL_COMPLEX_TYPES, "vb");
        DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.LOCAL_ELEMENTS_TYPES, "ss");
        DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.GLOBAL_ELEMENTS_LOCAL_TYPES, "rd");
        CONTENT_TYPES.put("smart", "smart");
        CONTENT_TYPES.put("string", "string");
    }
}

