/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.psi.PsiElement;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsPsiItem
extends BreadcrumbsItem {
    private final PsiElement myElement;
    private final BreadcrumbsInfoProvider myProvider;
    private CrumbPresentation myPresentation;

    public BreadcrumbsPsiItem(@NotNull PsiElement element, @NotNull BreadcrumbsInfoProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsPsiItem", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/xml/breadcrumbs/BreadcrumbsPsiItem", "<init>"));
        }
        this.myElement = element;
        this.myProvider = provider;
    }

    public void setPresentation(CrumbPresentation presentation) {
        this.myPresentation = presentation;
    }

    public String getDisplayText() {
        return this.isValid() ? this.myProvider.getElementInfo(this.myElement) : "INVALID";
    }

    public String getTooltip() {
        String s2 = this.isValid() ? this.myProvider.getElementTooltip(this.myElement) : "";
        return s2 == null ? "" : s2;
    }

    public CrumbPresentation getPresentation() {
        return this.myPresentation;
    }

    public boolean isValid() {
        return this.myElement != null && this.myElement.isValid();
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }
}

