/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.Gray;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsPsiItem;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
implements BreadcrumbsItemListener<BreadcrumbsPsiItem>,
Disposable {
    private final BreadcrumbsComponent<BreadcrumbsPsiItem> myComponent;
    private final Project myProject;
    private Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    private final VirtualFile myFile;
    private boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final BreadcrumbsInfoProvider myInfoProvider;
    private final Update myUpdate;
    public static final Key<BreadcrumbsXmlWrapper> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");

    public BreadcrumbsXmlWrapper(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "<init>"));
        }
        this.myUserCaretChange = true;
        this.myUpdate = new MyUpdate(this);
        this.myEditor = editor;
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)this);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addPropertyChangeListener(this::updateEditorFont, this);
        }
        Project project2 = editor.getProject();
        assert (project2 != null);
        this.myProject = project2;
        Document document = this.myEditor.getDocument();
        this.myFile = FileDocumentManager.getInstance().getFile(document);
        FileStatusManager manager = FileStatusManager.getInstance((Project)project2);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsXmlWrapper.this.updateCrumbs();
            }
        }, (Disposable)this);
        this.myInfoProvider = BreadcrumbsXmlWrapper.findInfoProvider(BreadcrumbsXmlWrapper.findViewProvider(this.myFile, this.myProject));
        CaretAdapter caretListener2 = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e2) {
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.queueUpdate();
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener((CaretListener)caretListener2);
        Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener2){
            final /* synthetic */ CaretListener val$caretListener;
            {
                this.val$caretListener = caretListener2;
            }

            public void dispose() {
                editor.getCaretModel().removeCaretListener(this.val$caretListener);
            }
        });
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                VirtualFile file2;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "propertyChanged"));
                }
                PsiFile psiFile = event.getFile();
                VirtualFile virtualFile = file2 = psiFile == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)file2, (Object)BreadcrumbsXmlWrapper.this.myFile)) {
                    return;
                }
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "childrenChanged"));
                }
                this.propertyChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "childMoved"));
                }
                this.propertyChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "childReplaced"));
                }
                this.propertyChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "childRemoved"));
                }
                this.propertyChanged(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4", "childAdded"));
                }
                this.propertyChanged(event);
            }
        }, (Disposable)this);
        this.myComponent = new BreadcrumbsComponent();
        this.myComponent.addBreadcrumbsItemListener((BreadcrumbsItemListener)this);
        this.myComponent.setFont(BreadcrumbsXmlWrapper.getEditorFont(this.myEditor));
        final EditorGutterComponentImpl gutterComponent = ((EditorImpl)editor).getGutterComponentEx();
        final ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                BreadcrumbsXmlWrapper.this.myComponent.setOffset(gutterComponent.getWhitespaceSeparatorOffset());
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }
        };
        this.myComponent.addComponentListener((ComponentListener)resizeListener);
        gutterComponent.addComponentListener(resizeListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                BreadcrumbsXmlWrapper.this.myComponent.removeComponentListener((ComponentListener)resizeListener);
                gutterComponent.removeComponentListener(resizeListener);
            }
        });
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, this.myComponent);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector(this.myComponent, (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        this.myComponent.setBorder((Border)new JBEmptyBorder((Insets)JBUI.insets((int)2, (int)0, (int)1, (int)2)));
        this.queueUpdate();
    }

    private void updateCrumbs() {
        if (this.myComponent != null && this.myEditor != null && !this.myEditor.isDisposed()) {
            this.myComponent.setFont(BreadcrumbsXmlWrapper.getEditorFont(this.myEditor));
            this.updateCrumbs(this.myEditor.getCaretModel().getLogicalPosition());
        }
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    private void moveEditorCaretTo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "moveEditorCaretTo"));
        }
        if (element.isValid()) {
            this.setUserCaretChange(false);
            this.myEditor.getCaretModel().moveToOffset(element.getTextOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    private static BreadcrumbsInfoProvider findProviderForElement(@NotNull PsiElement element, BreadcrumbsInfoProvider defaultProvider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "findProviderForElement"));
        }
        BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.getInfoProvider(element.getLanguage());
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<BreadcrumbsPsiItem> items2) {
        PsiElement[] elements = new PsiElement[items2.size()];
        int index = 0;
        for (BreadcrumbsPsiItem item : items2) {
            elements[index++] = item.getPsiElement();
        }
        return elements;
    }

    @Nullable
    private static CrumbPresentation[] getCrumbPresentations(PsiElement[] elements) {
        for (BreadcrumbsPresentationProvider provider : (BreadcrumbsPresentationProvider[])BreadcrumbsPresentationProvider.EP_NAME.getExtensions()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    private void setUserCaretChange(boolean userCaretChange) {
        this.myUserCaretChange = userCaretChange;
    }

    @Nullable
    private static LinkedList<BreadcrumbsPsiItem> getPresentableLineElements(@NotNull LogicalPosition position, VirtualFile file2, Editor editor, Project project2, BreadcrumbsInfoProvider defaultInfoProvider) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getPresentableLineElements"));
        }
        LinkedList<BreadcrumbsPsiItem> result2 = BreadcrumbsXmlWrapper.getLineElements(editor.logicalPositionToOffset(position), file2, project2, defaultInfoProvider);
        if (result2 == null) {
            return null;
        }
        PsiElement[] elements = BreadcrumbsXmlWrapper.toPsiElementArray(result2);
        CrumbPresentation[] presentations = BreadcrumbsXmlWrapper.getCrumbPresentations(elements);
        if (presentations != null) {
            int i2 = 0;
            for (BreadcrumbsPsiItem item : result2) {
                item.setPresentation(presentations[i2++]);
            }
        }
        return result2;
    }

    @Nullable
    public static PsiElement[] getLinePsiElements(int offset, VirtualFile file2, Project project2, BreadcrumbsInfoProvider infoProvider) {
        LinkedList<BreadcrumbsPsiItem> lineElements = BreadcrumbsXmlWrapper.getLineElements(offset, file2, project2, infoProvider);
        return lineElements != null ? BreadcrumbsXmlWrapper.toPsiElementArray(lineElements) : null;
    }

    @Nullable
    private static LinkedList<BreadcrumbsPsiItem> getLineElements(int offset, VirtualFile file2, Project project2, BreadcrumbsInfoProvider defaultInfoProvider) {
        PsiElement element = BreadcrumbsXmlWrapper.findFirstBreadcrumbedElement(offset, file2, project2, defaultInfoProvider);
        if (element == null) {
            return null;
        }
        LinkedList<BreadcrumbsPsiItem> result2 = new LinkedList<BreadcrumbsPsiItem>();
        while (element != null) {
            BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                result2.addFirst(new BreadcrumbsPsiItem(element, provider));
            }
            element = BreadcrumbsXmlWrapper.getParent(element, provider);
        }
        return result2;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file2, Project project2, BreadcrumbsInfoProvider defaultInfoProvider) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        PriorityQueue leafs = new PriorityQueue(3, (o1, o2) -> o2.getTextRange().getStartOffset() - o1.getTextRange().getStartOffset());
        FileViewProvider viewProvider = BreadcrumbsXmlWrapper.findViewProvider(file2, project2);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull(leafs, (Object)viewProvider.findElementAt(offset, language));
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            if (!element.isValid()) continue;
            BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                return element;
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull(leafs, (Object)BreadcrumbsXmlWrapper.getParent(element, provider));
        }
        return null;
    }

    @Nullable
    private static PsiElement getParent(@NotNull PsiElement element, @Nullable BreadcrumbsInfoProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getParent"));
        }
        return provider != null ? provider.getParent(element) : element.getParent();
    }

    @Nullable
    private static FileViewProvider findViewProvider(VirtualFile file2, Project project2) {
        if (file2 == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project2).findViewProvider(file2);
    }

    private void updateCrumbs(LogicalPosition position) {
        if (this.myFile != null && this.myEditor != null && !this.myEditor.isDisposed() && !this.myProject.isDisposed()) {
            if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                return;
            }
            this.myComponent.setItems(BreadcrumbsXmlWrapper.getPresentableLineElements(position, this.myFile, this.myEditor, this.myProject, this.myInfoProvider));
        }
    }

    @Nullable
    public static BreadcrumbsInfoProvider findInfoProvider(@Nullable FileViewProvider viewProvider) {
        if (EditorSettingsExternalizable.getInstance().isBreadcrumbsShown() && viewProvider != null) {
            Language baseLang = viewProvider.getBaseLanguage();
            BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.getInfoProvider(baseLang);
            if (provider != null) {
                return provider;
            }
            for (Language language : viewProvider.getLanguages()) {
                provider = BreadcrumbsXmlWrapper.getInfoProvider(language);
                if (provider == null) continue;
                return provider;
            }
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void itemSelected(@NotNull BreadcrumbsPsiItem item, int modifiers) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "itemSelected"));
        }
        PsiElement psiElement = item.getPsiElement();
        this.moveEditorCaretTo(psiElement);
        if (BitUtil.isSet((int)modifiers, (int)1) || BitUtil.isSet((int)modifiers, (int)4)) {
            TextRange range = psiElement.getTextRange();
            this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public void itemHovered(@Nullable BreadcrumbsPsiItem item) {
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter2 : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter2);
            }
            this.myHighlighed = null;
        }
        if (item != null) {
            TextRange range = item.getPsiElement().getTextRange();
            TextAttributes attributes = new TextAttributes();
            CrumbPresentation p2 = item.getPresentation();
            Color color = p2 != null ? p2.getBackgroundColor(false, false, false) : BreadcrumbsComponent.ButtonSettings.getBackgroundColor((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            Color background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR);
            attributes.setBackgroundColor(XmlTagTreeHighlightingUtil.makeTransparent(color, background != null ? background : Gray._200, 0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range.getStartOffset(), range.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsComponent(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getBreadcrumbsComponent"));
        }
        return (BreadcrumbsXmlWrapper)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
    }

    @Nullable
    private static BreadcrumbsInfoProvider getInfoProvider(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getInfoProvider"));
        }
        for (BreadcrumbsInfoProvider provider : (BreadcrumbsInfoProvider[])Extensions.getExtensions((ExtensionPointName)BreadcrumbsInfoProvider.EP_NAME)) {
            for (Language language1 : provider.getLanguages()) {
                if (!language.isKindOf(language1)) continue;
                return provider;
            }
        }
        return null;
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getEditorFont(Editor editor) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor.getColorsScheme().getFontPreferences(), null).getFont();
    }

    private static class MyUpdate
    extends Update {
        private final BreadcrumbsXmlWrapper myBreadcrumbsComponent;

        public MyUpdate(@NonNls BreadcrumbsXmlWrapper c2) {
            super((Object)c2);
            this.myBreadcrumbsComponent = c2;
        }

        public void run() {
            this.myBreadcrumbsComponent.updateCrumbs();
        }

        public boolean canEat(Update update2) {
            return true;
        }
    }
}

