/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlContentParticle;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentGroup;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dtd.BaseXmlElementDescriptorImpl;
import com.intellij.xml.impl.dtd.XmlElementsGroupImpl;
import com.intellij.xml.impl.dtd.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlNSDescriptorSequence;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementDescriptorImpl
extends BaseXmlElementDescriptorImpl
implements PsiWritableMetaData {
    protected XmlElementDecl myElementDecl;
    private String myName;
    private static final Class[] ourParentClassesToScanAttributes = new Class[]{XmlMarkupDecl.class, XmlDocument.class};
    private static final Key<CachedValue<XmlAttlistDecl[]>> ourCachedAttlistKeys = Key.create((String)"cached_declarations");
    private static final UserDataCache<CachedValue<XmlAttlistDecl[]>, XmlElement, Object> myAttlistDeclCache = new UserDataCache<CachedValue<XmlAttlistDecl[]>, XmlElement, Object>(){

        protected final CachedValue<XmlAttlistDecl[]> compute(XmlElement owner, Object o2) {
            return CachedValuesManager.getManager((Project)owner.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)XmlElementDescriptorImpl.doCollectAttlistDeclarations(owner), new Object[]{owner}));
        }
    };

    public XmlElementDescriptorImpl(XmlElementDecl elementDecl) {
        this.init((PsiElement)elementDecl);
    }

    public XmlElementDescriptorImpl() {
    }

    public PsiElement getDeclaration() {
        return this.myElementDecl;
    }

    public String getName(PsiElement context2) {
        return this.getName();
    }

    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        this.myName = this.myElementDecl.getName();
        return this.myName;
    }

    public void init(PsiElement element) {
        this.myElementDecl = (XmlElementDecl)element;
    }

    public Object[] getDependences() {
        return new Object[]{this.myElementDecl, ExternalResourceManager.getInstance()};
    }

    public XmlNSDescriptor getNSDescriptor() {
        return XmlElementDescriptorImpl.getNsDescriptorFrom((PsiElement)this.myElementDecl);
    }

    @Nullable
    private static XmlNSDescriptor getNsDescriptorFrom(PsiElement elementDecl) {
        XmlFile file2 = XmlUtil.getContainingFile(elementDecl);
        if (file2 == null) {
            return null;
        }
        XmlDocument document = file2.getDocument();
        assert (document != null);
        XmlNSDescriptor descriptor2 = (XmlNSDescriptor)document.getMetaData();
        return descriptor2 == null ? document.getDefaultNSDescriptor("", false) : descriptor2;
    }

    @Override
    protected final XmlElementDescriptor[] doCollectXmlDescriptors(XmlTag context2) {
        final LinkedHashSet result2 = new LinkedHashSet();
        XmlElementContentSpec contentSpecElement = this.myElementDecl.getContentSpecElement();
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        final XmlNSDescriptor NSDescriptor = nsDescriptor != null ? nsDescriptor : XmlElementDescriptorImpl.getNsDescriptorFrom((PsiElement)context2);
        XmlUtil.processXmlElements((XmlElement)contentSpecElement, new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/xml/impl/dtd/XmlElementDescriptorImpl$2", "execute"));
                }
                if (child instanceof XmlToken) {
                    XmlToken token = (XmlToken)child;
                    if (token.getTokenType() == XmlTokenType.XML_NAME) {
                        String text2 = child.getText();
                        XmlElementDescriptor element = XmlElementDescriptorImpl.getElementDescriptor(text2, NSDescriptor);
                        if (element != null) {
                            result2.add(element);
                        }
                    } else if (token.getTokenType() == XmlTokenType.XML_CONTENT_ANY) {
                        if (NSDescriptor instanceof XmlNSDescriptorImpl) {
                            ContainerUtil.addAll((Collection)result2, (Object[])((XmlNSDescriptorImpl)NSDescriptor).getElements());
                        } else if (NSDescriptor instanceof XmlNSDescriptorSequence) {
                            for (XmlNSDescriptor xmlNSDescriptor : ((XmlNSDescriptorSequence)NSDescriptor).getSequence()) {
                                if (!(xmlNSDescriptor instanceof XmlNSDescriptorImpl)) continue;
                                ContainerUtil.addAll((Collection)result2, (Object[])((XmlNSDescriptorImpl)xmlNSDescriptor).getElements());
                            }
                        }
                    }
                }
                return true;
            }
        }, true, false, (PsiFile)XmlUtil.getContainingFile(this.getDeclaration()));
        return result2.toArray(new XmlElementDescriptor[result2.size()]);
    }

    private static XmlElementDescriptor getElementDescriptor(String text2, XmlNSDescriptor NSDescriptor) {
        XmlElementDescriptor element = null;
        if (NSDescriptor instanceof XmlNSDescriptorImpl) {
            element = ((XmlNSDescriptorImpl)NSDescriptor).getElementDescriptor(text2);
        } else if (NSDescriptor instanceof XmlNSDescriptorSequence) {
            List<XmlNSDescriptor> sequence = ((XmlNSDescriptorSequence)NSDescriptor).getSequence();
            for (XmlNSDescriptor xmlNSDescriptor : sequence) {
                if (xmlNSDescriptor instanceof XmlNSDescriptorImpl && (element = ((XmlNSDescriptorImpl)xmlNSDescriptor).getElementDescriptor(text2)) != null) break;
            }
        } else {
            element = null;
        }
        return element;
    }

    @Override
    protected final XmlAttributeDescriptor[] collectAttributeDescriptors(XmlTag context2) {
        SmartList result2 = new SmartList();
        for (XmlAttlistDecl attlistDecl : this.findAttlistDeclarations(this.getName())) {
            for (XmlAttributeDecl attributeDecl : attlistDecl.getAttributeDecls()) {
                PsiMetaData psiMetaData = attributeDecl.getMetaData();
                assert (psiMetaData instanceof XmlAttributeDescriptor);
                result2.add((XmlAttributeDescriptor)psiMetaData);
            }
        }
        return result2.toArray(new XmlAttributeDescriptor[result2.size()]);
    }

    @Override
    protected HashMap<String, XmlAttributeDescriptor> collectAttributeDescriptorsMap(XmlTag context2) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = this.getAttributesDescriptors(context2);
        HashMap<String, XmlAttributeDescriptor> localADM = new HashMap<String, XmlAttributeDescriptor>(xmlAttributeDescriptors.length);
        for (XmlAttributeDescriptor xmlAttributeDescriptor : xmlAttributeDescriptors) {
            localADM.put(xmlAttributeDescriptor.getName(), xmlAttributeDescriptor);
        }
        return localADM;
    }

    private XmlAttlistDecl[] findAttlistDeclarations(String elementName) {
        ArrayList<XmlAttlistDecl> result2 = new ArrayList<XmlAttlistDecl>();
        for (XmlAttlistDecl declaration : this.getAttlistDeclarations()) {
            String name = declaration.getName();
            if (name == null || !name.equals(elementName)) continue;
            result2.add(declaration);
        }
        return result2.toArray(new XmlAttlistDecl[result2.size()]);
    }

    private XmlAttlistDecl[] getAttlistDeclarations() {
        return XmlElementDescriptorImpl.getCachedAttributeDeclarations((XmlElement)this.getDeclaration());
    }

    @NotNull
    public static XmlAttlistDecl[] getCachedAttributeDeclarations(@Nullable XmlElement owner) {
        if (owner == null) {
            if (XmlAttlistDecl.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dtd/XmlElementDescriptorImpl", "getCachedAttributeDeclarations"));
            }
            return XmlAttlistDecl.EMPTY_ARRAY;
        }
        if ((owner = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)owner, (Class[])ourParentClassesToScanAttributes)) == null) {
            if (XmlAttlistDecl.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dtd/XmlElementDescriptorImpl", "getCachedAttributeDeclarations"));
            }
            return XmlAttlistDecl.EMPTY_ARRAY;
        }
        XmlAttlistDecl[] xmlAttlistDeclArray = (XmlAttlistDecl[])((CachedValue)myAttlistDeclCache.get(ourCachedAttlistKeys, (UserDataHolder)owner, null)).getValue();
        if (xmlAttlistDeclArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dtd/XmlElementDescriptorImpl", "getCachedAttributeDeclarations"));
        }
        return xmlAttlistDeclArray;
    }

    private static XmlAttlistDecl[] doCollectAttlistDeclarations(XmlElement xmlElement) {
        ArrayList result2 = new ArrayList();
        XmlUtil.processXmlElements(xmlElement, new FilterElementProcessor((ElementFilter)new ClassFilter(XmlAttlistDecl.class), result2), false, false, (PsiFile)XmlUtil.getContainingFile((PsiElement)xmlElement));
        return result2.toArray(new XmlAttlistDecl[result2.size()]);
    }

    @Override
    public XmlElementsGroup getTopGroup() {
        XmlElementContentGroup topGroup = this.myElementDecl.getContentSpecElement().getTopGroup();
        return topGroup == null ? null : new XmlElementsGroupImpl((XmlContentParticle)topGroup, null);
    }

    public int getContentType() {
        if (this.myElementDecl.getContentSpecElement().isAny()) {
            return 1;
        }
        if (this.myElementDecl.getContentSpecElement().hasChildren()) {
            return 2;
        }
        if (this.myElementDecl.getContentSpecElement().isEmpty()) {
            return 0;
        }
        if (this.myElementDecl.getContentSpecElement().isMixed()) {
            return 3;
        }
        return 1;
    }

    @Override
    protected HashMap<String, XmlElementDescriptor> collectElementDescriptorsMap(XmlTag element) {
        XmlElementDescriptor[] descriptors = this.getElementsDescriptors(element);
        HashMap<String, XmlElementDescriptor> elementDescriptorsMap = new HashMap<String, XmlElementDescriptor>(descriptors.length);
        for (XmlElementDescriptor descriptor2 : descriptors) {
            elementDescriptorsMap.put(descriptor2.getName(), descriptor2);
        }
        return elementDescriptorsMap;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public void setName(String name) throws IncorrectOperationException {
        this.myName = null;
    }
}

