/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.FieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementsGroupProcessor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ComplexTypeDescriptor
extends TypeDescriptor {
    private static final Logger LOG = Logger.getInstance(ComplexTypeDescriptor.class);
    protected final XmlNSDescriptorImpl myDocumentDescriptor;
    private static final FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myElementDescriptorsCache = new FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected XmlElementDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p2) {
            return complexTypeDescriptor.doCollectElements(p2);
        }

        protected XmlElementDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object p2) {
            return complexTypeDescriptor.myElementDescriptors;
        }

        protected void putValue(XmlElementDescriptor[] xmlElementDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p2) {
            ComplexTypeDescriptor.access$102(complexTypeDescriptor, xmlElementDescriptors);
        }
    };
    private static final FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myAttributeDescriptorsCache = new FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected final XmlAttributeDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p2) {
            return complexTypeDescriptor.doCollectAttributes(p2);
        }

        protected final XmlAttributeDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object o2) {
            return complexTypeDescriptor.myAttributeDescriptors;
        }

        protected final void putValue(XmlAttributeDescriptor[] xmlAttributeDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p2) {
            ComplexTypeDescriptor.access$302(complexTypeDescriptor, xmlAttributeDescriptors);
        }
    };
    private final FactoryMap<String, CachedValue<CanContainAttributeType>> myAnyAttributeCache = new ConcurrentFactoryMap<String, CachedValue<CanContainAttributeType>>(){

        protected CachedValue<CanContainAttributeType> create(String key) {
            return CachedValuesManager.getManager((Project)ComplexTypeDescriptor.this.myTag.getProject()).createCachedValue(() -> {
                THashSet dependencies = new THashSet();
                CanContainAttributeType type = ComplexTypeDescriptor.this._canContainAttribute(key, ComplexTypeDescriptor.this.myTag, null, (Set)new THashSet(), (Set)dependencies);
                if (dependencies.isEmpty()) {
                    dependencies.add((Object)ComplexTypeDescriptor.this.myTag.getContainingFile());
                }
                if (DumbService.isDumb((Project)ComplexTypeDescriptor.this.myTag.getProject())) {
                    dependencies.add((Object)DumbService.getInstance((Project)ComplexTypeDescriptor.this.myTag.getProject()).getModificationTracker());
                }
                return CachedValueProvider.Result.create((Object)((Object)type), (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
            }, false);
        }
    };
    private volatile XmlElementDescriptor[] myElementDescriptors;
    private volatile XmlAttributeDescriptor[] myAttributeDescriptors;
    @NonNls
    private static final String PROHIBITED_ATTR_VALUE = "prohibited";
    @NonNls
    private static final String OTHER_NAMESPACE_ATTR_VALUE = "##other";
    @NonNls
    private static final String TRUE_ATTR_VALUE = "true";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    private boolean myHasAnyInContentModel;
    @NonNls
    private static final String RESTRICTION_TAG_NAME = "restriction";
    @NonNls
    private static final String EXTENSION_TAG_NAME = "extension";
    @NonNls
    private static final String BASE_ATTR_NAME = "base";

    public ComplexTypeDescriptor(XmlNSDescriptorImpl documentDescriptor, XmlTag tag) {
        super(tag);
        this.myDocumentDescriptor = documentDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return XmlElementsGroupProcessor.computeGroups(this.myDocumentDescriptor, this.myTag);
    }

    public XmlElementDescriptor[] getElements(XmlElement context2) {
        return (XmlElementDescriptor[])myElementDescriptorsCache.get(null, (Object)this, (Object)context2);
    }

    private XmlElementDescriptor[] doCollectElements(@Nullable XmlElement context2) {
        LinkedHashMap<String, XmlElementDescriptor> map2 = new LinkedHashMap<String, XmlElementDescriptor>(5);
        this.createProcessor(map2).startProcessing(this.myTag);
        ComplexTypeDescriptor.addSubstitutionGroups(map2, this.myDocumentDescriptor, new HashSet<XmlNSDescriptorImpl>());
        ComplexTypeDescriptor.filterAbstractElements(map2);
        return map2.values().toArray(new XmlElementDescriptor[map2.values().size()]);
    }

    protected XmlSchemaTagsProcessor createProcessor(final Map<String, XmlElementDescriptor> map2) {
        return new XmlSchemaTagsProcessor(this.myDocumentDescriptor, new String[0]){

            @Override
            protected void tagStarted(XmlTag tag, String tagName2, XmlTag context2, @Nullable XmlTag ref) {
                String refName = ref == null ? null : ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                ComplexTypeDescriptor.this.addElementDescriptor(tag, tagName2, map2, refName);
            }
        };
    }

    protected void addElementDescriptor(XmlTag tag, String tagName2, Map<String, XmlElementDescriptor> map2, @Nullable String refName) {
        if (ELEMENT_TAG_NAME.equals(tagName2) && tag.getAttribute(NAME_ATTR_NAME) != null) {
            XmlElementDescriptor element = this.myDocumentDescriptor.createElementDescriptor(tag);
            String name = refName == null ? element.getName() : refName;
            ComplexTypeDescriptor.addElementDescriptor(map2, element, name);
        }
    }

    private static void addSubstitutionGroups(Map<String, XmlElementDescriptor> result2, XmlNSDescriptorImpl nsDescriptor, Set<XmlNSDescriptorImpl> visited) {
        block0: while (true) {
            for (XmlElementDescriptor xmlElementDescriptor : result2.values()) {
                XmlElementDescriptorImpl descriptor2 = (XmlElementDescriptorImpl)xmlElementDescriptor;
                XmlElementDescriptor[] substitutes = nsDescriptor.getSubstitutes(descriptor2.getName(), descriptor2.getNamespace());
                boolean toContinue = false;
                for (XmlElementDescriptor substitute : substitutes) {
                    if (result2.get(substitute.getName()) != null) continue;
                    toContinue = true;
                    result2.put(substitute.getName(), substitute);
                }
                if (!toContinue) continue;
                continue block0;
            }
            break;
        }
        visited.add(nsDescriptor);
        for (XmlTag tag : nsDescriptor.getTag().getSubTags()) {
            PsiMetaData metaData;
            XmlDocument document;
            PsiFileSystemItem element;
            XmlAttributeValue valueElement;
            XmlAttribute location;
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, "include") || (location = tag.getAttribute("schemaLocation")) == null || (valueElement = location.getValueElement()) == null || !((element = new FileReferenceSet((PsiElement)valueElement).resolve()) instanceof XmlFile) || (document = ((XmlFile)element).getDocument()) == null || !((metaData = document.getMetaData()) instanceof XmlNSDescriptorImpl) || visited.contains(metaData)) continue;
            ComplexTypeDescriptor.addSubstitutionGroups(result2, (XmlNSDescriptorImpl)metaData, visited);
        }
    }

    private static void filterAbstractElements(Map<String, XmlElementDescriptor> result2) {
        Iterator<XmlElementDescriptor> iterator2 = result2.values().iterator();
        while (iterator2.hasNext()) {
            XmlElementDescriptorImpl descriptor2 = (XmlElementDescriptorImpl)iterator2.next();
            if (!descriptor2.isAbstract()) continue;
            iterator2.remove();
        }
    }

    public XmlAttributeDescriptor[] getAttributes(@Nullable XmlElement context2) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get(null, (Object)this, (Object)context2);
    }

    private XmlAttributeDescriptor[] doCollectAttributes(@Nullable XmlElement context2) {
        final ArrayList result2 = new ArrayList();
        XmlSchemaTagsProcessor processor2 = new XmlSchemaTagsProcessor(this.myDocumentDescriptor, new String[]{ELEMENT_TAG_NAME}){

            @Override
            protected void tagStarted(XmlTag tag, String tagName2, XmlTag context2, XmlTag ref) {
                if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(tagName2)) {
                    String name = tag.getAttributeValue(ComplexTypeDescriptor.NAME_ATTR_NAME);
                    if (name == null) {
                        return;
                    }
                    String use2 = null;
                    if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(context2.getLocalName())) {
                        use2 = context2.getAttributeValue("use");
                    }
                    if (use2 == null) {
                        use2 = tag.getAttributeValue("use");
                    }
                    if (ComplexTypeDescriptor.PROHIBITED_ATTR_VALUE.equals(use2)) {
                        ComplexTypeDescriptor.removeAttributeDescriptor(result2, name, null);
                    } else {
                        XmlAttributeDescriptorImpl descriptor2 = ComplexTypeDescriptor.this.myDocumentDescriptor.createAttributeDescriptor(tag);
                        descriptor2.myUse = use2;
                        if (ref != null) {
                            descriptor2.myReferenceName = ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                        }
                        ComplexTypeDescriptor.addAttributeDescriptor(result2, descriptor2);
                    }
                }
            }
        };
        processor2.startProcessing(this.myTag);
        return result2.toArray(new XmlAttributeDescriptor[result2.size()]);
    }

    public XmlNSDescriptorImpl getNsDescriptor() {
        return this.myDocumentDescriptor;
    }

    protected static void addElementDescriptor(Map<String, XmlElementDescriptor> result2, XmlElementDescriptor element, String name) {
        XmlElementDescriptor removed = result2.remove(name);
        if (removed != null) {
            LOG.info(removed + " is replaced by " + element);
        }
        result2.put(name, element);
    }

    private static void removeAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, String name, String referenceName) {
        Iterator<XmlAttributeDescriptorImpl> iterator2 = result2.iterator();
        while (iterator2.hasNext()) {
            XmlAttributeDescriptorImpl descriptor2 = iterator2.next();
            if (!descriptor2.getName().equals(name) || referenceName != null && !referenceName.equals(descriptor2.myReferenceName)) continue;
            iterator2.remove();
        }
    }

    private static void addAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, XmlAttributeDescriptorImpl descriptor2) {
        ComplexTypeDescriptor.removeAttributeDescriptor(result2, descriptor2.getName(), descriptor2.myReferenceName);
        result2.add(descriptor2);
    }

    public boolean canContainTag(String localName, String namespace, XmlElement context2) {
        return this._canContainTag(localName, namespace, this.myTag, context2, new HashSet<XmlTag>(5), new CurrentContextInfo(this.myDocumentDescriptor, this.myDocumentDescriptor.getDefaultNamespace()), false);
    }

    static CurrentContextInfo getContextInfo(CurrentContextInfo info, String ref) {
        XmlTag rootTag = info.documentDescriptor.getTag();
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, ref, info.documentDescriptor);
        String ns = nsDescriptor == info.documentDescriptor ? rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(ref)) : nsDescriptor.getDefaultNamespace();
        if (Comparing.equal((String)info.expectedDefaultNs, (String)ns) && info.documentDescriptor == nsDescriptor) {
            return info;
        }
        return new CurrentContextInfo(nsDescriptor, ns);
    }

    private boolean _canContainTag(String localName, String namespace, XmlTag tag, XmlElement context2, Set<XmlTag> visited, CurrentContextInfo info, boolean restriction) {
        String ref;
        if (visited.contains(tag)) {
            return false;
        }
        visited.add(tag);
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "any")) {
            if (!restriction) {
                this.myHasAnyInContentModel = true;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(tag.getAttributeValue("namespace"))) {
                return namespace == null || !namespace.equals(info.expectedDefaultNs);
            }
            return true;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "group")) {
            XmlTag groupTag;
            ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && (groupTag = info.documentDescriptor.findGroup(ref)) != null && this._canContainTag(localName, namespace, groupTag, context2, visited, ComplexTypeDescriptor.getContextInfo(info, ref), restriction)) {
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) {
            ComplexTypeDescriptor complexTypeDescriptor;
            TypeDescriptor descriptor2;
            String base = tag.getAttributeValue(BASE_ATTR_NAME);
            if (base != null && (descriptor2 = info.documentDescriptor.findTypeDescriptor(base)) instanceof ComplexTypeDescriptor && (complexTypeDescriptor = (ComplexTypeDescriptor)descriptor2)._canContainTag(localName, namespace, complexTypeDescriptor.myTag, context2, visited, ComplexTypeDescriptor.getContextInfo(info, base), restriction || XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME))) {
                this.myHasAnyInContentModel |= complexTypeDescriptor.myHasAnyInContentModel;
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
            PsiElement psiElement;
            XmlAttributeValue element;
            ref = tag.getAttribute(REF_ATTR_NAME);
            XmlTag descriptorTag = tag;
            if (ref != null && (element = ref.getValueElement()) != null && (psiElement = SchemaReferencesProvider.createTypeOrElementOrAttributeReference((PsiElement)element).resolve()) instanceof XmlTag) {
                descriptorTag = (XmlTag)psiElement;
            }
            if (TRUE_ATTR_VALUE.equals(descriptorTag.getAttributeValue("abstract"))) {
                String substitutionValue;
                XmlNSDescriptor _nsDescriptor = tag.getNSDescriptor(namespace, true);
                if (_nsDescriptor == null && context2 instanceof XmlTag) {
                    _nsDescriptor = ((XmlTag)context2).getNSDescriptor(namespace, true);
                }
                XmlNSDescriptorImpl nsDescriptor = _nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)_nsDescriptor : null;
                XmlElementDescriptor descriptor3 = nsDescriptor != null ? nsDescriptor.getElementDescriptor(localName, namespace) : null;
                String name = descriptorTag.getAttributeValue(NAME_ATTR_NAME);
                if (descriptor3 != null && name != null && (substitutionValue = ((XmlTag)descriptor3.getDeclaration()).getAttributeValue("substitutionGroup")) != null && name.equals(XmlUtil.findLocalNameByQualifiedName(substitutionValue))) {
                    return true;
                }
            }
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!this._canContainTag(localName, namespace, subTag, context2, visited, info, restriction)) continue;
            return true;
        }
        return false;
    }

    public CanContainAttributeType canContainAttribute(String namespace, @Nullable String qName) {
        if (qName == null) {
            return (CanContainAttributeType)((Object)((CachedValue)this.myAnyAttributeCache.get((Object)namespace)).getValue());
        }
        return this._canContainAttribute(namespace, this.myTag, qName, (Set<String>)new THashSet(), null);
    }

    private CanContainAttributeType _canContainAttribute(String namespace, XmlTag tag, @Nullable String qName, Set<String> visited, @Nullable Set<Object> dependencies) {
        XmlTag[] subTags;
        String base;
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "anyAttribute")) {
            if (dependencies != null) {
                dependencies.add(tag.getContainingFile());
            }
            String ns = tag.getAttributeValue("namespace");
            CanContainAttributeType canContainAttributeType = CanContainAttributeType.CanContainButDoNotSkip;
            if ("skip".equals(tag.getAttributeValue("processContents"))) {
                canContainAttributeType = CanContainAttributeType.CanContainButSkip;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(ns)) {
                return !namespace.equals(this.myDocumentDescriptor.getDefaultNamespace()) ? canContainAttributeType : CanContainAttributeType.CanNotContain;
            }
            if ("##any".equals(ns)) {
                return CanContainAttributeType.CanContainAny;
            }
            return canContainAttributeType;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "attributeGroup")) {
            String ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && !visited.contains(ref)) {
                visited.add(ref);
                XmlTag groupTag = this.myDocumentDescriptor.findAttributeGroup(ref);
                if (groupTag != null) {
                    CanContainAttributeType containAttributeType;
                    if (dependencies != null) {
                        dependencies.add(groupTag.getContainingFile());
                    }
                    if ((containAttributeType = this._canContainAttribute(namespace, groupTag, qName, visited, dependencies)) != CanContainAttributeType.CanNotContain) {
                        return containAttributeType;
                    }
                }
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ATTRIBUTE_TAG_NAME)) {
            if (qName != null && qName.equals(tag.getAttributeValue(REF_ATTR_NAME))) {
                return CanContainAttributeType.CanContainButDoNotSkip;
            }
        } else if ((XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) && (base = tag.getAttributeValue(BASE_ATTR_NAME)) != null && !visited.contains(base)) {
            visited.add(base);
            TypeDescriptor descriptor2 = this.myDocumentDescriptor.findTypeDescriptor(base);
            if (descriptor2 instanceof ComplexTypeDescriptor) {
                CanContainAttributeType containAttributeType;
                ComplexTypeDescriptor complexTypeDescriptor = (ComplexTypeDescriptor)descriptor2;
                if (dependencies != null) {
                    dependencies.add(((ComplexTypeDescriptor)descriptor2).getDeclaration().getContainingFile());
                }
                if ((containAttributeType = complexTypeDescriptor._canContainAttribute(namespace, complexTypeDescriptor.getDeclaration(), qName, visited, dependencies)) != CanContainAttributeType.CanNotContain) {
                    return containAttributeType;
                }
            }
        }
        for (XmlTag subTag : subTags = tag.getSubTags()) {
            CanContainAttributeType containAttributeType = this._canContainAttribute(namespace, subTag, qName, visited, dependencies);
            if (containAttributeType == CanContainAttributeType.CanNotContain) continue;
            return containAttributeType;
        }
        return CanContainAttributeType.CanNotContain;
    }

    public boolean hasAnyInContentModel() {
        return this.myHasAnyInContentModel;
    }

    public int getContentType() {
        if ("simpleType".equals(this.myTag.getLocalName()) || TRUE_ATTR_VALUE.equals(this.myTag.getAttributeValue("mixed"))) {
            return 3;
        }
        if (this.getElements(null).length > 0) {
            return 2;
        }
        for (XmlTag tag : this.myTag.getSubTags()) {
            if (!"simpleContent".equals(tag.getLocalName())) continue;
            return 3;
        }
        return 0;
    }

    public String toString() {
        return this.myTag.getAttributeValue(NAME_ATTR_NAME);
    }

    static /* synthetic */ XmlElementDescriptor[] access$102(ComplexTypeDescriptor x0, XmlElementDescriptor[] x1) {
        x0.myElementDescriptors = x1;
        return x1;
    }

    static /* synthetic */ XmlAttributeDescriptor[] access$302(ComplexTypeDescriptor x0, XmlAttributeDescriptor[] x1) {
        x0.myAttributeDescriptors = x1;
        return x1;
    }

    static enum CanContainAttributeType {
        CanContainButSkip,
        CanContainButDoNotSkip,
        CanContainAny,
        CanNotContain;

    }

    static class CurrentContextInfo {
        final XmlNSDescriptorImpl documentDescriptor;
        final String expectedDefaultNs;

        public CurrentContextInfo(XmlNSDescriptorImpl _nsDescriptor, String _ns) {
            this.documentDescriptor = _nsDescriptor;
            this.expectedDefaultNs = _ns;
        }
    }
}

