/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.NamedObjectDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import com.intellij.xml.impl.schema.XsdEnumerationDescriptor;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementDescriptorImpl
extends XsdEnumerationDescriptor<XmlTag>
implements XmlElementDescriptor,
PsiWritableMetaData,
Validator<XmlTag>,
XmlElementDescriptorAwareAboutChildren {
    protected XmlTag myDescriptorTag;
    protected volatile XmlNSDescriptor NSDescriptor;
    @Nullable
    private volatile Validator<XmlTag> myValidator;
    @NonNls
    public static final String QUALIFIED_ATTR_VALUE = "qualified";
    @NonNls
    public static final String NONQUALIFIED_ATTR_VALUE = "unqualified";
    @NonNls
    private static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";

    public XmlElementDescriptorImpl(@Nullable XmlTag descriptorTag) {
        this.myDescriptorTag = descriptorTag;
    }

    public XmlElementDescriptorImpl() {
    }

    @Override
    public XmlTag getDeclaration() {
        return this.myDescriptorTag;
    }

    public String getName(PsiElement context2) {
        String value2 = this.myDescriptorTag.getAttributeValue("name");
        if (context2 instanceof XmlElement) {
            String namespacePrefix;
            String namespace = this.getNamespaceByContext(context2);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class, (boolean)false);
            if (tag != null && (namespacePrefix = tag.getPrefixByNamespace(namespace)) != null && namespacePrefix.length() > 0) {
                String elementFormDefault;
                XmlTag rootTag = ((XmlFile)this.myDescriptorTag.getContainingFile()).getRootTag();
                value2 = rootTag != null && (NONQUALIFIED_ATTR_VALUE.equals(elementFormDefault = rootTag.getAttributeValue(ELEMENT_FORM_DEFAULT)) || elementFormDefault == null) && tag.getNamespaceByPrefix("").isEmpty() && this.myDescriptorTag.getParentTag() != rootTag ? XmlUtil.findLocalNameByQualifiedName(value2) : namespacePrefix + ":" + XmlUtil.findLocalNameByQualifiedName(value2);
            }
        }
        return value2;
    }

    public String getName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName(null));
    }

    public String getNamespaceByContext(PsiElement context2) {
        return this.getNamespace();
    }

    public String getNamespace() {
        String name = this.getName();
        if (name == null) {
            return "";
        }
        if (this.getNSDescriptor() == null || this.myDescriptorTag == null) {
            return "";
        }
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        return namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
    }

    public void init(PsiElement element) {
        if (this.myDescriptorTag != element && this.myDescriptorTag != null) {
            this.NSDescriptor = null;
        }
        this.myDescriptorTag = (XmlTag)element;
    }

    public Object[] getDependences() {
        return new Object[]{this.myDescriptorTag};
    }

    private XmlNSDescriptor getNSDescriptor(XmlElement context2) {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        if (context2 instanceof XmlTag && nsDescriptor instanceof XmlNSDescriptorImpl) {
            String defaultNamespace = ((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace();
            if ("http://www.w3.org/2001/XMLSchema".equals(defaultNamespace)) {
                return nsDescriptor;
            }
            XmlTag tag = (XmlTag)context2;
            String tagNs = tag.getNamespace();
            if (tagNs.equals(defaultNamespace)) {
                XmlNSDescriptor previousDescriptor = nsDescriptor;
                nsDescriptor = tag.getNSDescriptor(tagNs, true);
                if (nsDescriptor == null) {
                    nsDescriptor = previousDescriptor;
                }
            }
        }
        return nsDescriptor;
    }

    public XmlNSDescriptor getNSDescriptor() {
        XmlNSDescriptor nsDescriptor = this.NSDescriptor;
        if (nsDescriptor == null || !this.NSDescriptor.getDeclaration().isValid()) {
            XmlFile file2 = XmlUtil.getContainingFile((PsiElement)this.getDeclaration());
            if (file2 == null) {
                return null;
            }
            XmlDocument document = file2.getDocument();
            if (document == null) {
                return null;
            }
            this.NSDescriptor = nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        return nsDescriptor;
    }

    public XmlElementsGroup getTopGroup() {
        TypeDescriptor type = this.getType();
        return type instanceof ComplexTypeDescriptor ? ((ComplexTypeDescriptor)type).getTopGroup() : null;
    }

    @Nullable
    public TypeDescriptor getType() {
        return this.getType(null);
    }

    @Nullable
    public TypeDescriptor getType(XmlElement context2) {
        TypeDescriptor typeDescriptor;
        XmlNSDescriptor descriptor2;
        XmlTag tag;
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(context2);
        if (!(nsDescriptor instanceof XmlNSTypeDescriptorProvider)) {
            return null;
        }
        TypeDescriptor type = ((XmlNSTypeDescriptorProvider)nsDescriptor).getTypeDescriptor(this.myDescriptorTag);
        if (type == null) {
            String substAttr = this.myDescriptorTag.getAttributeValue("substitutionGroup");
            if (substAttr != null) {
                String namespacePrefix = XmlUtil.findPrefixByQualifiedName(substAttr);
                String namespace = namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
                String local = XmlUtil.findLocalNameByQualifiedName(substAttr);
                XmlElementDescriptorImpl originalElement = (XmlElementDescriptorImpl)((XmlNSDescriptorImpl)this.getNSDescriptor()).getElementDescriptor(local, namespace);
                if (originalElement != null && originalElement != this) {
                    type = originalElement.getType(context2);
                }
            }
        } else if (context2 instanceof XmlTag && nsDescriptor instanceof XmlNSDescriptorImpl && !(tag = (XmlTag)context2).getNamespace().equals(((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace()) && (descriptor2 = tag.getNSDescriptor(tag.getNamespace(), true)) != nsDescriptor && descriptor2 instanceof XmlNSTypeDescriptorProvider && (typeDescriptor = ((XmlNSTypeDescriptorProvider)descriptor2).getTypeDescriptor(this.myDescriptorTag)) != null && typeDescriptor.getDeclaration() != type.getDeclaration()) {
            return typeDescriptor;
        }
        return type;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        XmlElementDescriptor parentDescriptorByType;
        if (context2 != null && (parentDescriptorByType = XmlUtil.findXmlDescriptorByType(context2)) != null && !parentDescriptorByType.equals(this)) {
            return parentDescriptorByType.getElementsDescriptors(context2);
        }
        Object[] elementsDescriptors = this.getElementsDescriptorsImpl((XmlElement)context2);
        TypeDescriptor type = this.getType((XmlElement)context2);
        if (type instanceof ComplexTypeDescriptor) {
            PsiFile containingFile;
            ComplexTypeDescriptor descriptor2 = (ComplexTypeDescriptor)type;
            PsiFile psiFile = containingFile = context2 != null ? context2.getContainingFile() : null;
            if (context2 != null && !containingFile.isPhysical()) {
                containingFile = containingFile.getOriginalFile();
            }
            if (context2 != null) {
                XmlNSDescriptor nsDescriptor;
                String contextNs = context2.getNamespace();
                if (descriptor2.canContainTag(context2.getLocalName(), contextNs, (XmlElement)context2) && (!contextNs.equals(this.getNamespace()) || descriptor2.hasAnyInContentModel()) && containingFile instanceof XmlFile && (nsDescriptor = this.getNSDescriptor()) != null) {
                    elementsDescriptors = (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])elementsDescriptors, (Object[])nsDescriptor.getRootElementsDescriptors(((XmlFile)containingFile).getDocument()));
                }
            }
        }
        return elementsDescriptors;
    }

    private XmlElementDescriptor[] getElementsDescriptorsImpl(XmlElement context2) {
        TypeDescriptor type = this.getType(context2);
        if (type instanceof ComplexTypeDescriptor) {
            String[] namespaces;
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            XmlElementDescriptor[] elements = typeDescriptor.getElements(context2);
            if (context2 instanceof XmlTag && elements.length > 0 && (namespaces = ((XmlTag)context2).knownNamespaces()).length > 1) {
                ArrayList<XmlElementDescriptor> result2 = new ArrayList<XmlElementDescriptor>(Arrays.asList(elements));
                for (String namespace : namespaces) {
                    XmlNSDescriptor descriptor2;
                    if (namespace.equals(typeDescriptor.getNsDescriptor().getDefaultNamespace()) || !((descriptor2 = ((XmlTag)context2).getNSDescriptor(namespace, false)) instanceof XmlNSDescriptorImpl) || !((XmlNSDescriptorImpl)descriptor2).hasSubstitutions()) continue;
                    for (XmlElementDescriptor element : elements) {
                        String name = XmlUtil.getLocalName(element.getName((PsiElement)context2)).toString();
                        String s2 = ((XmlNSDescriptorImpl)element.getNSDescriptor()).getDefaultNamespace();
                        XmlElementDescriptor[] substitutes = ((XmlNSDescriptorImpl)descriptor2).getSubstitutes(name, s2);
                        result2.addAll(Arrays.asList(substitutes));
                    }
                }
                return result2.toArray(new XmlElementDescriptor[result2.size()]);
            }
            return elements;
        }
        return EMPTY_ARRAY;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context2) {
        TypeDescriptor type = this.getType((XmlElement)context2);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            XmlAttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributes((XmlElement)context2);
            if (context2 != null) {
                String contextNs = context2.getNamespace();
                boolean seenXmlNs = false;
                for (String ns : context2.knownNamespaces()) {
                    if (contextNs.equals(ns) || ns.length() <= 0) continue;
                    seenXmlNs |= "http://www.w3.org/XML/1998/namespace".equals(ns);
                    attributeDescriptors = XmlElementDescriptorImpl.updateAttributeDescriptorsFromAny(context2, typeDescriptor, attributeDescriptors, ns);
                }
                if (!seenXmlNs) {
                    attributeDescriptors = XmlElementDescriptorImpl.updateAttributeDescriptorsFromAny(context2, typeDescriptor, attributeDescriptors, "http://www.w3.org/XML/1998/namespace");
                }
            }
            return attributeDescriptors;
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    private static XmlAttributeDescriptor[] updateAttributeDescriptorsFromAny(XmlTag context2, ComplexTypeDescriptor typeDescriptor, XmlAttributeDescriptor[] attributeDescriptors, String ns) {
        XmlNSDescriptor descriptor2;
        if (typeDescriptor.canContainAttribute(ns, null) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain && (descriptor2 = context2.getNSDescriptor(ns, true)) instanceof XmlNSDescriptorImpl) {
            Object[] rootDescriptors = ((XmlNSDescriptorImpl)descriptor2).getRootAttributeDescriptors(context2);
            attributeDescriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])attributeDescriptors, (Object[])rootDescriptors);
        }
        return attributeDescriptors;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context2) {
        return this.getAttributeDescriptorImpl(attributeName, context2);
    }

    @Nullable
    private XmlAttributeDescriptor getAttributeDescriptorImpl(String attributeName, XmlTag context2) {
        XmlNSDescriptor candidateNSDescriptor;
        ComplexTypeDescriptor.CanContainAttributeType containAttributeType;
        String namespacePrefix;
        String namespace;
        String localName = XmlUtil.findLocalNameByQualifiedName(attributeName);
        XmlAttributeDescriptor attribute = this.getAttribute(localName, namespace = (namespacePrefix = XmlUtil.findPrefixByQualifiedName(attributeName)).isEmpty() ? this.getDefaultNamespace() : context2.getNamespaceByPrefix(namespacePrefix), context2, attributeName);
        if (attribute instanceof AnyXmlAttributeDescriptor && (containAttributeType = ((AnyXmlAttributeDescriptor)attribute).getCanContainAttributeType()) != ComplexTypeDescriptor.CanContainAttributeType.CanContainAny && !namespace.isEmpty() && (candidateNSDescriptor = context2.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)candidateNSDescriptor;
            XmlAttributeDescriptor xmlAttributeDescriptor = nsDescriptor.getAttribute(localName, namespace, context2);
            if (xmlAttributeDescriptor != null) {
                return xmlAttributeDescriptor;
            }
            if (containAttributeType == ComplexTypeDescriptor.CanContainAttributeType.CanContainButDoNotSkip) {
                attribute = null;
            }
        }
        return attribute;
    }

    private String getDefaultNamespace() {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        return nsDescriptor instanceof XmlNSDescriptorImpl ? ((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace() : "";
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptorImpl(attribute.getName(), attribute.getParent());
    }

    @Nullable
    private XmlAttributeDescriptor getAttribute(String attributeName, String namespace, XmlTag context2, String qName) {
        ComplexTypeDescriptor descriptor2;
        ComplexTypeDescriptor.CanContainAttributeType containAttributeType;
        XmlAttributeDescriptor[] descriptors;
        for (XmlAttributeDescriptor descriptor3 : descriptors = this.getAttributesDescriptors(context2)) {
            if (!descriptor3.getName().equals(attributeName) || !descriptor3.getName((PsiElement)context2).equals(qName)) continue;
            return descriptor3;
        }
        TypeDescriptor type = this.getType((XmlElement)context2);
        if (type instanceof ComplexTypeDescriptor && (containAttributeType = (descriptor2 = (ComplexTypeDescriptor)type).canContainAttribute(namespace, qName)) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain) {
            return new AnyXmlAttributeDescriptor(attributeName, containAttributeType);
        }
        return null;
    }

    public int getContentType() {
        TypeDescriptor type = this.getType();
        if (type instanceof ComplexTypeDescriptor) {
            return ((ComplexTypeDescriptor)type).getContentType();
        }
        return 3;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(String name) {
        String localName = XmlUtil.findLocalNameByQualifiedName(name);
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        String namespace = namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
        return this.getElementDescriptor(localName, namespace, null, name);
    }

    @Nullable
    protected XmlElementDescriptor getElementDescriptor(String localName, String namespace, XmlElement context2, String fullName) {
        ComplexTypeDescriptor descriptor2;
        XmlElementDescriptor[] elements;
        for (XmlElementDescriptor element1 : elements = this.getElementsDescriptorsImpl(context2)) {
            XmlNSDescriptor descriptor3;
            XmlElementDescriptorImpl element = (XmlElementDescriptorImpl)element1;
            String namespaceByContext = element.getNamespaceByContext((PsiElement)context2);
            if (!element.getName().equals(localName)) continue;
            if (namespace == null || namespace.equals(namespaceByContext) || namespaceByContext.equals("") || element.getName((PsiElement)context2).equals(fullName) || namespace.length() == 0 && element.getDefaultName().equals(fullName)) {
                return element;
            }
            XmlNSDescriptor xmlNSDescriptor = descriptor3 = context2 instanceof XmlTag ? ((XmlTag)context2).getNSDescriptor(namespace, true) : null;
            if (!(descriptor3 instanceof XmlNSDescriptorImpl)) continue;
            if (((XmlNSDescriptorImpl)descriptor3).getDefaultNamespace().equals(namespaceByContext)) {
                return element;
            }
            ((XmlNSDescriptorImpl)descriptor3).getSubstitutes(localName, namespace);
        }
        TypeDescriptor type = this.getType(context2);
        if (type instanceof ComplexTypeDescriptor && (descriptor2 = (ComplexTypeDescriptor)type).canContainTag(localName, namespace, context2)) {
            return new AnyXmlElementDescriptor(this, this.getNSDescriptor());
        }
        return null;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag element, XmlTag contextTag) {
        XmlElement context2 = (XmlElement)element.getParent();
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(element.getLocalName(), element.getNamespace(), context2, element.getName());
        if (elementDescriptor == null || element.getAttributeValue("xsi:type") != null) {
            XmlElementDescriptor parentXmlDescriptorByType;
            XmlElementDescriptor xmlDescriptorByType = XmlUtil.findXmlDescriptorByType(element);
            if (xmlDescriptorByType != null) {
                elementDescriptor = xmlDescriptorByType;
            } else if (context2 instanceof XmlTag && ((XmlTag)context2).getAttributeValue("xsi:type") != null && this.askParentDescriptorViaXsi() && (parentXmlDescriptorByType = XmlUtil.findXmlDescriptorByType((XmlTag)context2)) != null) {
                elementDescriptor = parentXmlDescriptorByType.getElementDescriptor(element, contextTag);
            }
        }
        return elementDescriptor;
    }

    protected boolean askParentDescriptorViaXsi() {
        return true;
    }

    public String getQualifiedName() {
        String ns = this.getNS();
        if (ns != null && !ns.isEmpty()) {
            return ns + ":" + this.getName();
        }
        return this.getName();
    }

    @Nullable
    private String getNS() {
        return XmlUtil.findNamespacePrefixByURI((XmlFile)this.myDescriptorTag.getContainingFile(), this.getNamespace());
    }

    public String getDefaultName() {
        XmlTag rootTag;
        PsiFile psiFile = this.myDescriptorTag.getContainingFile();
        XmlTag xmlTag = rootTag = psiFile instanceof XmlFile ? ((XmlFile)psiFile).getRootTag() : null;
        if (rootTag != null && QUALIFIED_ATTR_VALUE.equals(rootTag.getAttributeValue(ELEMENT_FORM_DEFAULT))) {
            return this.getQualifiedName();
        }
        return this.getName();
    }

    public boolean isAbstract() {
        return XmlElementDescriptorImpl.isAbstractDeclaration(this.myDescriptorTag);
    }

    public static Boolean isAbstractDeclaration(XmlTag descriptorTag) {
        return Boolean.valueOf(descriptorTag.getAttributeValue("abstract"));
    }

    public void setName(String name) throws IncorrectOperationException {
        NamedObjectDescriptor.setName(this.myDescriptorTag, name);
    }

    public void setValidator(Validator<XmlTag> validator) {
        this.myValidator = validator;
    }

    @Override
    public void validate(@NotNull XmlTag context2, @NotNull Validator.ValidationHost host) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/impl/schema/XmlElementDescriptorImpl", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/xml/impl/schema/XmlElementDescriptorImpl", "validate"));
        }
        Validator<XmlTag> validator = this.myValidator;
        if (validator != null) {
            validator.validate(context2, host);
        }
    }

    @Override
    public PsiReference[] getValueReferences(XmlTag xmlTag, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xml/impl/schema/XmlElementDescriptorImpl", "getValueReferences"));
        }
        XmlTagValue value2 = xmlTag.getValue();
        XmlText[] elements = value2.getTextElements();
        if (elements.length == 0 || xmlTag.getSubTags().length > 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new XmlEnumeratedValueReference((XmlElement)xmlTag, this, ElementManipulators.getValueTextRange((PsiElement)xmlTag))};
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context2) {
        TypeDescriptor type = this.getType((XmlElement)context2);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            return typeDescriptor.canContainTag("a", namespace, (XmlElement)context2) || typeDescriptor.getNsDescriptor().hasSubstitutions() || XmlUtil.nsFromTemplateFramework(namespace);
        }
        return false;
    }

    public String toString() {
        String namespace;
        try {
            namespace = this.getNamespace();
        }
        catch (PsiInvalidElementAccessException e2) {
            namespace = "!!!Invalid!!!";
        }
        return this.getName() + " (" + namespace + ")";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        XmlElementDescriptorImpl that = (XmlElementDescriptorImpl)o2;
        return !(this.myDescriptorTag != null ? !this.myDescriptorTag.equals(that.myDescriptorTag) : that.myDescriptorTag != null);
    }

    public int hashCode() {
        return this.myDescriptorTag != null ? this.myDescriptorTag.hashCode() : 0;
    }
}

