/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");
    private static final String NULL_STRING = "\"\"";

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file2, Project project2, PsiFile context2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "getNamespace"));
        }
        if (DumbService.isDumb((Project)project2) || context2 != null && XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file2);
        }
        List list2 = FileBasedIndex.getInstance().getValues(NAME, (Object)file2.getUrl(), XmlNamespaceIndex.createFilter(project2));
        return list2.size() == 0 ? null : ((XsdNamespaceBuilder)list2.get(0)).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "computeNamespace"));
        }
        InputStream stream = null;
        try {
            stream = file2.getInputStream();
            String string2 = XsdNamespaceBuilder.computeNamespace(stream);
            return string2;
        }
        catch (IOException e2) {
            String string3 = null;
            return string3;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project2, @Nullable Module module2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getResourcesByNamespace"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module2, project2, null);
        Collections.sort(resources);
        return resources;
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module2, @NotNull Project project2, @Nullable NullableFunction<List<IndexedRelevantResource<String, XsdNamespaceBuilder>>, IndexedRelevantResource<String, XsdNamespaceBuilder>> chooser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getAllResources"));
        }
        return IndexedRelevantResource.getAllResources(NAME, module2, project2, chooser);
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        DataIndexer<String, XsdNamespaceBuilder, FileContent> dataIndexer = new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                XsdNamespaceBuilder builder = "dtd".equals(inputData.getFile().getExtension()) ? new XsdNamespaceBuilder(inputData.getFileName(), "", Collections.emptyList(), Collections.emptyList()) : XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                HashMap<String, XsdNamespaceBuilder> map2 = new HashMap<String, XsdNamespaceBuilder>(2);
                String namespace = builder.getNamespace();
                if (namespace != null) {
                    map2.put(namespace, builder);
                }
                map2.put(inputData.getFile().getUrl(), builder);
                HashMap<String, XsdNamespaceBuilder> hashMap = map2;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        DataExternalizer<XsdNamespaceBuilder> dataExternalizer = new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/XmlNamespaceIndex$2", "save"));
                }
                IOUtil.writeUTF((DataOutput)out, (String)(value2.getNamespace() != null ? value2.getNamespace() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeUTF((DataOutput)out, (String)(value2.getVersion() != null ? value2.getVersion() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeStringList((DataOutput)out, value2.getTags());
                IOUtil.writeStringList((DataOutput)out, value2.getRootTags());
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                String version;
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/XmlNamespaceIndex$2", "read"));
                }
                String namespace = IOUtil.readUTF((DataInput)in);
                if (XmlNamespaceIndex.NULL_STRING.equals(namespace)) {
                    namespace = null;
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(version = IOUtil.readUTF((DataInput)in))) {
                    version = null;
                }
                return new XsdNamespaceBuilder(namespace, version, IOUtil.readStringList((DataInput)in), IOUtil.readStringList((DataInput)in));
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, @Nullable String tagName2, @Nullable String version, @Nullable String schemaLocation, @Nullable Module module2, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project2, module2);
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        String fileName = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, (o1, o2) -> {
            int i2;
            if (fileName != null && (i2 = Comparing.compare((boolean)fileName.equals(o1.getFile().getName()), (boolean)fileName.equals(o2.getFile().getName()))) != 0) {
                return i2;
            }
            if (tagName2 != null && (i2 = Comparing.compare((boolean)((XsdNamespaceBuilder)o1.getValue()).hasTag(tagName2), (boolean)((XsdNamespaceBuilder)o2.getValue()).hasTag(tagName2))) != 0) {
                return i2;
            }
            i2 = o1.compareTo(o2);
            if (i2 != 0) {
                return i2;
            }
            return ((XsdNamespaceBuilder)o1.getValue()).getRating(tagName2, version) - ((XsdNamespaceBuilder)o2.getValue()).getRating(tagName2, version);
        });
        if (tagName2 != null && !resource.getValue().hasTag(tagName2)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName2, @Nullable String version, @Nullable String schemaLocation, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        if (DumbService.isDumb((Project)file2.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName2, version, schemaLocation, ModuleUtilCore.findModuleForPsiElement((PsiElement)file2), file2.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file2);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/xml/index/XmlNamespaceIndex", "guessDtd"));
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list2 = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list2, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file2 = o1.getFile();
                    for (int i2 = split.length - 1; i2 >= 0 && file2 != null; file2 = file2.getParent(), --i2) {
                        String s2 = split[i2];
                        if (s2.equals(file2.getName())) continue;
                        return split.length - i2;
                    }
                    return 0;
                }
            });
        } else {
            resource = list2.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }
}

