/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class CheckDtdReferencesInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckDtdReferencesInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlElement(XmlElement element) {
                if (element instanceof XmlElementContentSpec || element instanceof XmlEntityRef) {
                    CheckDtdReferencesInspection.doCheckRefs(element, holder);
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckDtdReferencesInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static void doCheckRefs(XmlElement element, ProblemsHolder holder) {
        for (PsiReference ref : element.getReferences()) {
            String image;
            ProgressManager.checkCanceled();
            if (!XmlHighlightVisitor.hasBadResolve(ref, true) || ref.getElement() instanceof XmlElementContentSpec && ((image = ref.getCanonicalText()).equals("-") || image.equals("O"))) continue;
            holder.registerProblem(ref);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckDtdReferencesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string2 = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckDtdReferencesInspection", "getGroupDisplayName"));
        }
        return string2;
    }

    @NotNull
    public String getDisplayName() {
        String string2 = XmlBundle.message((String)"xml.inspections.check.dtd.references", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckDtdReferencesInspection", "getDisplayName"));
        }
        return string2;
    }
}

