/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode node;
                ASTNode child;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag) && (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) != null && (node = child.getTreeNext()) != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    Fix localQuickFix = new Fix();
                    holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? localQuickFix : null});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    static boolean isCollapsibleTag(XmlTag tag) {
        String name = tag.getName().toLowerCase();
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name) || XmlExtension.getExtensionByElement((PsiElement)tag).isCollapsibleTag(tag);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string2 = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getGroupDisplayName"));
        }
        return string2;
    }

    @NotNull
    public String getDisplayName() {
        String string2 = XmlBundle.message((String)"xml.inspections.check.tag.empty.body", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getDisplayName"));
        }
        return string2;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckTagEmptyBody" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getShortName"));
        }
        return "CheckTagEmptyBody";
    }

    public static class Fix
    extends CollapseTagIntention {
        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix", "isAvailable"));
            }
            return true;
        }
    }
}

