/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ColorIconCache {
    private static final ColorIconCache INSTANCE = new ColorIconCache();
    private static final SoftFactoryMap<Color, Map<Integer, Icon>> ourCache = new SoftFactoryMap<Color, Map<Integer, Icon>>(){

        protected Map<Integer, Icon> create(Color key) {
            return new HashMap();
        }
    };

    private ColorIconCache() {
    }

    public static ColorIconCache getIconCache() {
        return INSTANCE;
    }

    public Icon getIcon(@NotNull Color color, int size) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/xml/util/ColorIconCache", "getIcon"));
        }
        return ((Map)ourCache.get((Object)color)).computeIfAbsent(size, s2 -> {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/xml/util/ColorIconCache", "lambda$getIcon$0"));
            }
            return new ColorIcon((int)s2, color);
        });
    }

    public static class ColorIcon
    extends EmptyIcon {
        private Color myColor;
        private Color[] myColours;

        public ColorIcon(int size, Color color) {
            super(size);
            this.myColor = color;
        }

        public ColorIcon(int size, Color[] colours) {
            super(size);
            this.myColours = colours;
        }

        protected ColorIcon(ColorIcon icon) {
            super((EmptyIcon)icon);
            this.myColor = icon.myColor;
            if (icon.myColours != null) {
                this.myColours = Arrays.copyOf(icon.myColours, icon.myColours.length);
            }
        }

        @NotNull
        protected ColorIcon copy() {
            ColorIcon colorIcon = new ColorIcon(this);
            if (colorIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/ColorIconCache$ColorIcon", "copy"));
            }
            return colorIcon;
        }

        public void paintIcon(Component component, Graphics g2, int i2, int j2) {
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            if (this.myColor != null) {
                g2.setColor(this.myColor);
                g2.fillRect(i2, j2, iconWidth, iconHeight);
            } else if (this.myColours != null) {
                Color top = this.myColours[0];
                g2.setColor(top);
                g2.fillRect(i2, j2, iconWidth, 2);
                Color right = this.myColours[1];
                g2.setColor(right);
                g2.fillRect(i2 + iconWidth / 2, j2 + 2, iconWidth / 2, iconHeight / 2);
                Color bottom = this.myColours[2];
                g2.setColor(bottom);
                g2.fillRect(i2, j2 + iconHeight - 2, iconWidth, 2);
                Color left = this.myColours[3];
                g2.setColor(left);
                g2.fillRect(i2, j2 + 2, iconWidth / 2, iconHeight / 2);
            }
            Composite old = ((Graphics2D)g2).getComposite();
            ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2.setColor(Color.BLACK);
            g2.drawRect(i2, j2, iconWidth - 1, iconHeight - 1);
            ((Graphics2D)g2).setComposite(old);
        }
    }
}

